/*
 * Ʈ: TLE2Framework
 * ϸ: TLEConfigPathUtil.java
 * ۼ: 2004. 11. 16
 */
package tle.framework.util;

import tle.framework.TLEProperties;

/**
 *   θ ȯϱ  ƿƼ Ŭ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class TLEConfigPathUtil {
	/**
	 *   ִ  ο ؼ ȯ ۾ ش.
	 *  ΰ Ư ڿ    η üȴ.
	 * 
	 * <ul>
	 *   <li>{context.path} - TLEProperties.getProperty("context.path") ϰ 
	 *   <li>{user.home} -  Ȩ 丮  
	 * </ul>
	 * 
	 *  ش    ڿ ״ Ѵ.
	 * <p>
	 * TLEWebApplicationListener ʷ ϵǾ    ø̼  
	 * TLEProperties.setProperty("context.path", ؽƮ) ޼ҵ带 ȣֱ 
	 * TLEWebApplicationListener ʷ ϵǾ   
	 * ڰ  TLEProperties.setProperty("context.path", ؽƮ) ޼ҵ带
	 * ˸° ȣ־ Ѵ.
	 * 
	 * @param path
	 * @return ȯ 
	 */
	public static String replace(String path) {
		if (path == null) return path;
		if (path.startsWith(contextPath) && TLEProperties.getProperty("context.path") != null) {
			return TLEProperties.getProperty("context.path") + path.substring(contextPath.length());
		} else if (path.startsWith(userHome)) {
			return System.getProperty("user.home") + path.substring(userHome.length());
		}
		return path;
	}
	
	private static String contextPath = "{context.path}";
	private static String userHome = "{user.home}";
	
}
