/*
 * Ʈ: TLE2Framework
 * ϸ: ServiceManagerConfiguration.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager.service;

import java.util.ArrayList;
import java.util.List;

/**
 * 񽺿 õ    Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class ServiceManagerConfiguration {
	private List serviceGroupList = new ArrayList(10);
	private List serviceList = new ArrayList(64);
	
	public void addServiceGroup(String commandPrefix, String needAuth, String roles) {
		boolean needAuthentication = false;
		boolean allRoleUsable = false;
		String roleIDs = null;
		
		if (roles == null || roles.equals("*")) {
			allRoleUsable = true;
		} else {
			roleIDs = roles;
		}
		
		if (needAuth == null) {
			needAuthentication = false;
		}
		if (needAuth != null && needAuth.trim().compareToIgnoreCase("true") == 0) {
			needAuthentication = true;
		}
		
		ServiceGroup group = new ServiceGroup(commandPrefix, needAuthentication, allRoleUsable, roles);
		serviceGroupList.add(group);
	}
	
	public List getServiceGroupList() {
		return serviceGroupList;
	}
	
	public void addService(String commandID, String name, String description, String needAuth, String roles) {
		boolean needAuthentication = false;
		boolean allRoleUsable = false;
		String roleIDs = null;
		if (roles == null || roles.equals("*")) {
			allRoleUsable = true;
		} else {
			roleIDs = roles;
		}
		if (needAuth == null) {
			needAuthentication = false;
		}
		if (needAuth != null && needAuth.trim().compareToIgnoreCase("true") == 0) {
			needAuthentication = true;
		}
		ServiceImpl service = new ServiceImpl(commandID, name, description, needAuthentication, allRoleUsable, roleIDs);
		
		serviceList.add(service);
	}
	public List getServiceList() {
		return serviceList;
	}
}
