/*
 * Ʈ: TLE2Framework
 * ϸ: ServiceImpl.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager.service;

import java.util.Map;
import java.util.StringTokenizer;

import tle.framework.component.spi.aamanager.Role;
import tle.framework.component.spi.aamanager.Service;

/**
 * Service ü. ServiceManagerImpl Ѵ.
 * 
 * @author ֹ
 * @since 2.0 
 */
public class ServiceImpl implements Service, HasGrant {
	private String commandID;
	private String name;
	private String description;
	private boolean needAuthentication;
	private boolean allRolesUsable;
	private Map roleList = new java.util.HashMap();
	
	ServiceImpl(String commandID, String name, String description, boolean needAuth, boolean allRolesUsable, String roleIDs) {
		this.commandID = commandID;
		this.name = name;
		this.description = description;
		this.needAuthentication = needAuth;
		this.allRolesUsable = allRolesUsable;
		if (roleIDs != null) {
			StringTokenizer st = new StringTokenizer(roleIDs, ", ");
			while(st.hasMoreTokens()) {
				String roleID = (String)st.nextToken();
				roleList.put(roleID, roleID);
			}
		}
	}
	
	public String getCommandID() {
		return commandID;
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public boolean isNeedAuthentication() {
		return needAuthentication;
	}

	public boolean isAllRolesUsable() {
		return allRolesUsable;
	}
	
	/**
	 * roleID شϴ   񽺸   ִ 
	 * true Ѵ.
	 * 
	 * @param role 
	 * @return  񽺸 밡  true
	 */
	public boolean hasGrant(Role role) {
		return roleList.containsKey(role.getID());
	}
}
