/*
 * Ʈ: TLE2Framework
 * ϸ: ComponentState.java
 * ۼ: 2004. 10. 12.
 */
package tle.framework.component;

import tle.framework.util.statemachine.State;
import tle.framework.util.statemachine.StateMachine;

/**
 * Ʈ   Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class ComponentState {
	/** Ʈ  ̺Ʈ Ÿ */
	public static final String CREATE_EVENT = "create";
	/** Ʈ ʱȭ ̺Ʈ Ÿ */
	public static final String INIT_EVENT = "init";
	/** Ʈ  ̺Ʈ Ÿ */
	public static final String START_EVENT = "start";
	/** Ʈ  ̺Ʈ Ÿ */
	public static final String STOP_EVENT = "stop";
	/** Ʈ  ̺Ʈ Ÿ */
	public static final String CLOSE_EVENT = "close";
	/** Ʈ Ͻ  ̺Ʈ Ÿ */
	public static final String SUSPEND_EVENT = "suspend";
	/** Ʈ  ̺Ʈ Ÿ */
	public static final String RESUME_EVENT = "resume";
	/** Ʈ  Ϸ ̺Ʈ Ÿ */
	public static final String COMPLETE_EVENT = "complete";
	/** Ʈ  ̺Ʈ Ÿ */
	public static final String ERROR_EVENT = "error";
	
	/** Ʈ   ¸ Ÿ */
	private static State NOT_CREATED = new StateMachine.StartState();
	/** Ʈ  ¸ Ÿ */
	private static State CREATED = new State("CREATED", new Integer(0x01));
	/** Ʈ ʱȭ ¸ Ÿ */
	private static State INITING = new State("INITING", new Integer(0x02));
	/** Ʈ ȭ ¸ Ÿ */
	private static State INITED = new State("INITED", new Integer(0x04));
	/** Ʈ  ¸ Ÿ */
	private static State STARTING = new State("STARTING", new Integer(0x08));
	/** Ʈ  ¸ Ÿ */
	private static State RUNNING = new State("STARTED", new Integer(0x10));
	/** Ʈ  ¸ Ÿ */
	private static State STOPPING = new State("STOPPING", new Integer(0x20));
	/** Ʈ  ¸ Ÿ */
	private static State STOPPED = new State("STOPPED", new Integer(0x40));
	/** Ʈ  ¸ Ÿ */
	private static State CLOSING = new State("CLOSING", new Integer(0x80));
	/** Ʈ Ͻ ¸ Ÿ */
	private static State SUSPENDING = new State("SUSPENDING", new Integer(0x100));
	/** Ʈ Ͻ ¸ Ÿ */
	private static State SUSPENDED = new State("SUSPENDED", new Integer(0x200));
	/** Ʈ  ¸ Ÿ */
	private static State RESUMING = new State("RESUMING", new Integer(0x400));
	/** Ʈ  ¸ Ÿ */
	private static State CLOSED = new StateMachine.FinishState("CLOSED");
	/** Ʈ ߻ ¸ Ÿ */
	private static State ERROROCCURED = new State("ERROROCCURED", new Integer(0x1000));
	
	static {
		NOT_CREATED.addEvent(ComponentState.CREATE_EVENT, CREATED);
		CREATED.addEvent(ComponentState.INIT_EVENT, INITING);
		INITING.addEvent(ComponentState.COMPLETE_EVENT, INITED);
		INITED.addEvent(ComponentState.START_EVENT, STARTING);
		STARTING.addEvent(ComponentState.COMPLETE_EVENT, RUNNING);
		RUNNING.addEvent(ComponentState.STOP_EVENT, STOPPING);
		STOPPING.addEvent(ComponentState.COMPLETE_EVENT, STOPPED);
		STOPPED.addEvent(ComponentState.CLOSE_EVENT, CLOSING);
		CLOSING.addEvent(ComponentState.COMPLETE_EVENT, CLOSED);
		
		RUNNING.addEvent(ComponentState.SUSPEND_EVENT, SUSPENDING);
		SUSPENDING.addEvent(ComponentState.COMPLETE_EVENT, SUSPENDED);
		SUSPENDED.addEvent(ComponentState.RESUME_EVENT, RESUMING);
		RESUMING.addEvent(ComponentState.COMPLETE_EVENT, RUNNING);
		SUSPENDING.addEvent(ComponentState.STOP_EVENT, STOPPING);
		
		INITING.addEvent("error", ERROROCCURED);
		STARTING.addEvent("error", ERROROCCURED);
		STOPPING.addEvent("error", ERROROCCURED);
		CLOSING.addEvent("error", ERROROCCURED);
		SUSPENDING.addEvent("error", ERROROCCURED);
		RESUMING.addEvent("error", ERROROCCURED);
		ERROROCCURED.addEvent(ComponentState.COMPLETE_EVENT, CLOSED);
	}
	
	private StateMachine sm = new StateMachine(NOT_CREATED);
	
	/**
	 * NOT_CREATED º ϴ ComponentState Ѵ.
	 *
	 */
	public ComponentState() {
	}
	
	/**
	 * ̺Ʈ Ͽ ¸ Ѵ.
	 * 
	 * @param event
	 * @throws IllegalStateException
	 */
	public void event(String event) throws IllegalStateException {
		sm.transit(event);
	}
	
	public State getCurrentState() {
		return sm.getCurrentState();
	}
	
	public boolean isNotCreated() {
		return sm.getCurrentState() == ComponentState.NOT_CREATED;
	}
	public boolean isCreated() {
		return sm.getCurrentState() == ComponentState.CREATED;
	}
	public boolean isIniting() {
		return sm.getCurrentState() == ComponentState.INITING;
	}
	public boolean isInited() {
		return sm.getCurrentState() == ComponentState.INITED;
	}
	public boolean isStarting() {
		return sm.getCurrentState() == ComponentState.STARTING;
	}
	public boolean isRunning() {
		return sm.getCurrentState() == ComponentState.RUNNING;
	}
	public boolean isSuspending() {
		return sm.getCurrentState() == ComponentState.SUSPENDING;
	}
	public boolean isSuspended() {
		return sm.getCurrentState() == ComponentState.SUSPENDED;
	}
	public boolean isResuming() {
		return sm.getCurrentState() == ComponentState.RESUMING;
	}
	public boolean isStopping() {
		return sm.getCurrentState() == ComponentState.STOPPING;
	}
	public boolean isStopped() {
		return sm.getCurrentState() == ComponentState.STOPPED;
	}
	public boolean isClosing() {
		return sm.getCurrentState() == ComponentState.CLOSING;
	}
	public boolean isClosed() {
		return sm.getCurrentState() == ComponentState.CLOSED;
	}
	public boolean isErrorOccured() {
		return sm.getCurrentState() == ComponentState.ERROROCCURED;
	}
}