/*
 * Ʈ: TLE2Framework
 * ϸ: TLEConfigDigesterTest.java
 * ۼ: 2004. 10. 18
 */
package test.tle.framework.configuration;

import java.io.IOException;

import org.xml.sax.SAXException;

import tle.framework.component.ComponentConfig;
import tle.framework.configuration.TLEConfig;
import tle.framework.configuration.TLEConfigDigester;
import junit.framework.TestCase;

/**
 * TLEConfigDigester Ŭ ׽Ʈ
 * 
 * @author ֹ
 * @since 2.0
 */
public class TLEConfigDigesterTest extends TestCase {

	public void testCreate() throws IOException, SAXException {
		TLEConfig config = TLEConfigDigester.create("c:/eclipse/workspace/TLE2Framework/config/TLEFrameworkConfig.xml");
		ComponentConfig compConfig = config.getComponentConfig("DefaultAAManager");
		
		assertEquals("tle.framework.component.impl.aamanager.DefaultAAManager", compConfig.getComponentClass());
		assertEquals("DefaultAAManager", compConfig.getComponentID());
		
		compConfig = config.getComponentConfig("DefaultRequestAnalyzer");
		assertEquals("tle.framework.component.impl.ra.DefaultRequestAnalyzer", compConfig.getComponentClass());
		assertEquals("DefaultRequestAnalyzer", compConfig.getComponentID());
		
		assertEquals("DefaultRequestAnalyzer", config.getRequestAnalyzerID());
		assertEquals("DefaultRequestProcessor", config.getRequestProcessorID());
		assertEquals("DefaultUICreator", config.getUICreatorID());
		assertEquals("DefaultAAManager", config.getAAManagerID());
		
		assertEquals(true, config.getUseWrapper());
	}

}
