/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.aamanager.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import tle.framework.component.ComponentConfig;
import tle.framework.component.impl.aamanager.ServiceManager;
import tle.framework.component.impl.aamanager.service.HasGrant;
import tle.framework.component.impl.aamanager.service.ServiceGroup;
import tle.framework.component.impl.aamanager.service.ServiceGroupChain;
import tle.framework.component.impl.aamanager.service.ServiceImpl;
import tle.framework.component.impl.aamanager.service.ServiceManagerConfiguration;
import tle.framework.component.impl.aamanager.service.ServiceManagerConfigurationDigester;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.NullService;
import tle.framework.component.spi.aamanager.Role;
import tle.framework.component.spi.aamanager.Service;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.util.TLEConfigPathUtil;

public class ServiceManagerImpl
implements ServiceManager {
    private Map serviceMap = new HashMap();
    private List serviceGroupList = null;
    private Map serviceGroupChainCacheMap = new HashMap();

    public void init(ComponentConfig config) throws AAManagerException {
        this.loadConfiguration(config);
    }

    private void loadConfiguration(ComponentConfig config) throws AAManagerException {
        String configFile = config.getInitParameter("ServiceManagerImpl.configFile");
        try {
            HashMap<String, ServiceImpl> serviceMap = new HashMap<String, ServiceImpl>();
            ServiceManagerConfiguration configuration = ServiceManagerConfigurationDigester.create(TLEConfigPathUtil.replace(configFile));
            List serviceList = configuration.getServiceList();
            for (int i = 0; i < serviceList.size(); ++i) {
                ServiceImpl service = (ServiceImpl)serviceList.get(i);
                serviceMap.put(service.getCommandID(), service);
            }
            this.serviceGroupList = configuration.getServiceGroupList();
            this.serviceGroupChainCacheMap.clear();
            this.serviceMap = serviceMap;
        }
        catch (IOException e) {
            throw new AAManagerException("ServiceManagerImpl.init():\uc124\uc815\ud30c\uc77c \uc77d\uae30 \uc5d0\ub7ec", e);
        }
        catch (SAXException e) {
            throw new AAManagerException("ServiceManagerImpl.init():\uc124\uc815\ud30c\uc77c \uc77d\uae30 \uc5d0\ub7ec", e);
        }
    }

    public void reloadConfiguration(ComponentConfig config) throws AAManagerException {
        this.loadConfiguration(config);
    }

    public Service getService(RequestInfo ri) {
        String commandID = ri.getCommandID();
        Service service = (Service)this.serviceMap.get(commandID);
        if (service == null && (service = (ServiceGroupChain)this.serviceGroupChainCacheMap.get(ri.getCommandID())) == null) {
            ArrayList<ServiceGroup> groupChain = null;
            for (int i = 0; i < this.serviceGroupList.size(); ++i) {
                ServiceGroup group = (ServiceGroup)this.serviceGroupList.get(i);
                if (!commandID.startsWith(group.getCommandPrefix())) continue;
                if (groupChain == null) {
                    groupChain = new ArrayList<ServiceGroup>();
                }
                groupChain.add(group);
            }
            if (groupChain != null && groupChain.size() > 0) {
                ServiceGroupChain serviceGroupChain = new ServiceGroupChain();
                serviceGroupChain.setCommandID(commandID);
                for (int i = 0; i < groupChain.size(); ++i) {
                    serviceGroupChain.addServiceGroup((ServiceGroup)groupChain.get(i));
                }
                service = serviceGroupChain;
                this.serviceGroupChainCacheMap.put(serviceGroupChain.getCommandID(), serviceGroupChain);
            }
            if (service == null) {
                service = NullService.intance;
                this.serviceMap.put(commandID, service);
            }
        }
        if (service == null) {
            return NullService.intance;
        }
        return service;
    }

    public boolean hasGrant(Role role, Service service) {
        if (service instanceof HasGrant) {
            return ((HasGrant)((Object)service)).hasGrant(role);
        }
        return service instanceof NullService;
    }
}

