/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl;

import tle.framework.component.Component;
import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.ComponentState;

public abstract class ComponentBase
implements Component {
    protected ComponentState componentState = new ComponentState();
    protected ComponentConfig config = null;

    public ComponentBase() {
        this.componentState.event("create");
    }

    public String getID() {
        return this.config.getComponentID();
    }

    protected void initing(ComponentConfig config) throws ComponentException {
    }

    public final void init(ComponentConfig config) throws ComponentException {
        this.componentState.event("init");
        this.config = config;
        this.initing(config);
        this.componentState.event("complete");
    }

    protected void starting() throws ComponentException {
    }

    public final void start() throws ComponentException {
        this.componentState.event("start");
        this.starting();
        this.componentState.event("complete");
    }

    protected void suspending() throws ComponentException {
    }

    public final void suspend() throws ComponentException {
        this.componentState.event("suspend");
        this.suspending();
        this.componentState.event("complete");
    }

    protected void resuming() throws ComponentException {
    }

    public final void resume() throws ComponentException {
        this.componentState.event("resume");
        this.suspending();
        this.componentState.event("complete");
    }

    protected void stopping() throws ComponentException {
    }

    public final void stop() throws ComponentException {
        this.componentState.event("stop");
        this.suspending();
        this.componentState.event("complete");
    }

    protected void closing() throws ComponentException {
    }

    public final void close() throws ComponentException {
        this.componentState.event("close");
        this.closing();
        this.componentState.event("complete");
    }

    public String getDescription() {
        return this.config.getDescription();
    }

    public final String getState() {
        return this.componentState.getCurrentState().getStateName();
    }

    public boolean isCreated() {
        return this.componentState.isCreated();
    }

    public boolean isClosed() {
        return this.componentState.isClosed();
    }

    public boolean isClosing() {
        return this.componentState.isClosing();
    }

    public boolean isErrorOccured() {
        return this.componentState.isErrorOccured();
    }

    public boolean isInited() {
        return this.componentState.isInited();
    }

    public boolean isIniting() {
        return this.componentState.isIniting();
    }

    public boolean isResuming() {
        return this.componentState.isResuming();
    }

    public boolean isRunning() {
        return this.componentState.isRunning();
    }

    public boolean isStarting() {
        return this.componentState.isStarting();
    }

    public boolean isStopped() {
        return this.componentState.isStopped();
    }

    public boolean isStopping() {
        return this.componentState.isStopping();
    }

    public boolean isSuspended() {
        return this.componentState.isSuspended();
    }

    public boolean isSuspending() {
        return this.componentState.isSuspending();
    }
}

