<?php
    include_once('./classes/ArrayRecordSet.php');
	/**
	 * Manage schemas within a database
	 *
	 * $Id: database.php,v 1.88.2.3 2007/07/09 14:55:22 xzilla Exp $
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');

	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
	if (!isset($msg)) $msg = '';

	function _highlight($string, $term) {
		return str_replace($term, "<b>{$term}</b>", $string);
	}	

	/**
	 * Display a form for alter and perform actual alter
	 */
    function doAlter() {
        global $data, $misc, $db;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['stralter']);

        include_once "waiting.php";

        echo "<form action=\"all_db.php\" method=\"post\">\n";
        echo "<table>\n";
        echo "<tr><th class=\"data left required\">{$lang['strname']}</th>\n";
        echo "<td class=\"data1\">";
        echo "<input name=\"newname\" size=\"32\" maxlength=\"{$data->_maxDbLen}\" value=\"$db\" /></td></tr>\n";

        echo "</table>\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"alter\" />\n";
        echo $misc->form;
        echo "<input type=\"hidden\" name=\"oldname\" value=\"", 
            htmlspecialchars($db), "\" />\n";
        echo "<input type=\"submit\" name=\"alter\" value=\"{$lang['stralter']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }

    function doCopy() {
        global $data, $misc, $db;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strcopydb']);

        include_once "waiting.php";

        echo "<form action=\"all_db.php\" method=\"post\">\n";
        echo "<table>\n";
        echo "<tr><th class=\"data left required\">{$lang['strname']}</th>\n";
        echo "<td class=\"data1\">";
        echo "<input name=\"newname\" size=\"32\" maxlength=\"{$data->_maxDbLen}\" value=\"$db\" /></td></tr>\n";

        echo "</table>\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"copy\" />\n";
        echo $misc->form;
        echo "<input type=\"hidden\" name=\"oldname\" value=\"", 
            htmlspecialchars($db), "\" />\n";
        echo "<input type=\"submit\" name=\"alter\" value=\"{$lang['strcopydb']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }
	
	/**
	 * Show confirmation of drop and perform actual drop
	 */
    function doDrop() {
        global $data, $misc, $db;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strdrop']);

        include_once "waiting.php";

        echo "<p>", sprintf($lang['strconfdropdatabase'], $misc->printVal($db)), "</p>\n";	
        echo "<form action=\"all_db.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"drop\" />\n";
        echo $misc->form;
        echo "<input type=\"hidden\" name=\"dropdatabase\" value=\"", htmlspecialchars($db), "\" />\n";
        echo "<input type=\"submit\" name=\"drop\" value=\"{$lang['strdrop']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }


    function doAutovoladd($msg) {
        global $data, $misc, $db, $_server_info;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strvolumeautoadd']);
        $misc->printMsg($msg);

        include_once "waiting.php";

        $tk = $misc->ManagerCommand($_server_info['id'], "getautoaddvol" , "dbname:$db");
        if ($tk['status'] != "success") {
            echo "<br>".$tk['note']."<br>";
            return;
        }
        echo "<form action=\"database.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"autovoladd\" />\n";
        echo $misc->form;
        $onoffstr = array("OFF","ON");
        echo "1. ".$lang['strdata']." ".$lang['strvolumeautoadd']." ".$misc->radiomake($onoffstr, $tk['data'], "in_data")."<br>\n";
        echo "&nbsp;&nbsp;&nbsp;&nbsp;".$lang['strwarnoutofspace'].
            " <input type='text' name='in_datawarn' value='{$tk['data_warn_outofspace']}' size=5> MAX=0.3(30%)<br>\n";
        echo "&nbsp;&nbsp;&nbsp;&nbsp;".$lang['strextpage'].
            " <input type='text' name='in_datapage' value='{$tk['data_ext_page']}' size=9> MIN=1000<br>\n";
        echo "2. ".$lang['strindex']." ".$lang['strvolumeautoadd']." ".$misc->radiomake($onoffstr, $tk['index'], "in_index")."<br>\n";
        echo "&nbsp;&nbsp;&nbsp;&nbsp;".$lang['strwarnoutofspace'].
            " <input type='text' name='in_indexwarn' value='{$tk['index_warn_outofspace']}' size=5> MAX=0.3(30%)<br>\n";
        echo "&nbsp;&nbsp;&nbsp;&nbsp;".$lang['strextpage'].
            " <input type='text' name='in_indexpage' value='{$tk['index_ext_page']}' size=9> MIN=1000<br>\n";
        echo "<input type=\"hidden\" name=\"opdatabase\" value=\"", htmlspecialchars($db), "\" />\n";
        echo "<input type=\"submit\" name=\"voladd\" value=\"{$lang['strvolumeautoadd']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }

    function doVoladd($msg) {
        global $data, $misc, $db, $_server_info;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strvolumeadd']);
        $misc->printMsg($msg);

        include_once "waiting.php";

        $tk = $misc->ManagerCommand($_server_info['id'], "getaddvolstatus" , "dbname:$db");
        if ($tk['status'] != "success") {
            echo "<br>".$tk['note']."<br>";
            return;
        }
        echo "<form action=\"database.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"voladd\" />\n";
        echo $misc->form; 
        echo "1. ".$lang['strtargetdirectory']." <input type=text name='opdir' size='60' value='{$tk['volpath']}'>".
             " * Server<br>\n";
        echo "2. ".$lang['strextpage']." <input type='text' name='in_datapage' value='10000' size=9><br>\n";
        echo "3. ".
            "<input type='radio' name='add_type' value='data' checked> data &nbsp;".
            "<input type='radio' name='add_type' value='generic'> generic &nbsp;".
            "<input type='radio' name='add_type' value='index'> index &nbsp;".
            "<input type='radio' name='add_type' value='temp'> temp &nbsp;".
            "<br>\n";
        echo "&nbsp;&nbsp;&nbsp;&nbsp;* SIZE = pages * page size({$_server_info['pagesize'][$db]})<br>\n";

        echo "<input type=\"hidden\" name=\"opdatabase\" value=\"", htmlspecialchars($db), "\" />\n";
        echo "<input type=\"submit\" name=\"voladd\" value=\"{$lang['strvolumeadd']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }


    function doUnload() {
        global $data, $misc, $db, $_server_info;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strunloaddb']);

        include_once "waiting.php";

        echo "<p>", sprintf($lang['strconfdbop'], $lang['strunloaddb'], $misc->printVal($db)), "</p>\n";	

        $tk = $misc->getUnloadInfo($db);
        if (count($tk) > 0) {
            echo $lang['strunloaddb']." ".$lang['strhistory']."<ul>";
            for ($i = 0; $i < count($tk); $i ++) {
                echo "\t<li> ".$tk[$i][0]." ".$tk[$i][1]."(".$tk[$i][2].")</li>\n";
            }
            echo "</ul><br>\n";
        }

        echo "<form action=\"database.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"unload\" />\n";
        echo $misc->form;
        echo "<input type=\"hidden\" name=\"opdatabase\" value=\"", htmlspecialchars($db), "\" />\n";
        echo "1. ".$lang['strtargetdirectory']." <input type=text name='opdir' size='50' value='{$_server_info['dbdir'][$db]}'>".
             " * Server<br>\n";
        echo "2. ".$lang['strtargettable']." <input type=text name='optbls' size='40'> {$lang['stremptyisall']}<br>\n";
        echo "3. ".$lang['strstructureonly']."<input type='radio' name='opoption' value='0' checked> ".
            $lang['strdataonly']."<input type='radio' name='opoption' value='1'> ".
            $lang['strstructureanddata']."<input type='radio' name='opoption' value='2'><br>\n";
        echo "4. Prefix <input type=text name='opprefix' size='16'> * {$lang['strunloadprefix']}<br>\n";
        echo "<input type=\"submit\" name=\"op\" value=\"{$lang['strunloaddb']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }


    function doLoad() {
        global $data, $misc, $db, $_server_info;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strloaddb']);

        include_once "waiting.php";

        echo "<p>", sprintf($lang['strconfdbop'], $lang['strloaddb'], $misc->printVal($db)), "</p>\n";	

        $tk = $misc->getUnloadInfo("");
        if (count($tk) > 0) {
            echo $lang['strunloaddb']." ".$lang['strhistory']."<br>\n<textarea cols=80 rows=8>";
            for ($i = 0; $i < count($tk); $i ++) {
                echo $tk[$i][1]."(".$tk[$i][2].") {$tk[$i][0]}\n";
            }
            echo "</textarea><br>\n";
        }

        echo "<form action=\"database.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"load\" />\n";
        echo $misc->form;
        echo "<input type=\"hidden\" name=\"opdatabase\" value=\"", htmlspecialchars($db), "\" />\n";
        echo "1. ".$lang['strschema']." ".$lang['strfile'].
            " <input type=text name='opschema' size='60'> * Server<br>\n";
        echo "2. ".$lang['strdata']." ".$lang['strfile'].
            " <input type=text name='opdata' size='60'> * Server<br>\n";
        echo "3. ".$lang['strindex']." ".$lang['strfile'].
            " <input type=text name='opindex' size='60'> * Server<br>\n";
        echo "4. ".$lang['strtrigger']." ".$lang['strfile'].
            " <input type=text name='optrigger' size='60'> * Server<br>\n";
        echo "5. ".$lang['strloadonly']."<input type='radio' name='opoption' value='0' checked> ".
            $lang['strcheckonly']."<input type='radio' name='opoption' value='1'> ".
            $lang['strcheckandload']."<input type='radio' name='opoption' value='2'><br>\n";
        echo "<input type=\"submit\" name=\"op\" value=\"{$lang['strloaddb']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }


    function doBackupauto($msg = "") {
        global $data, $misc, $db, $_server_info;
        global $lang, $subact, $double_token_to, $opid;

        $misc->printTrail('database');
        $misc->printTitle($lang['strbackupauto']);
        $misc->printMsg($msg);

        include_once "waiting.php";

        $double_token_to = "array";
        $tk = $misc->ManagerCommand($_server_info['id'], "getbackupinfo" , "dbname:$db");
        $double_token_to = "lines";
        if ($tk['status'] != "success") {
            echo "<br>".$tk['note']."<br>";
            return;
        }
        else {
            $cnt = count($tk['dbname']);
            if ($cnt <= 1) {
                echo "<br>".$lang['strnodata']."<br>";
            }
            else {
                $col = array("backupid","period_type","period_date","time","level",
                    "archivedel","onoff","zip","check","mt");
                $dat = $misc->double_token_array_adjust($tk, $col, $cnt-1);
                $col = $misc->column_make($col);
                $col['actions']=array('title' => $lang['stractions']);
                $dat = new ArrayRecordSet($dat); 
                $act = array(
                    'edit' => array(
                        'title' => $lang['stredit'],
                        'url'   => "database.php?action=backupauto&amp;subact=edit&amp;subject=database&amp;{$misc->href}&amp;",
                        'vars'  => array('opid' => 'backupid'),
                    ),
                    'delete' => array(
                        'title' => $lang['strdelete'],
                        'url'   => "database.php?action=backupauto&amp;subact=del&amp;subject=database&amp;{$misc->href}&amp;",
                        'vars'  => array('opid' => 'backupid'),
                    ),
                );
                $misc->printTable($dat, $col, $act);
            }
        }
        echo "<input type=\"button\" value=\"{$lang['stradd']}\" ".
            "onclick='window.location=\"database.php?action=backupauto&amp;subact=edit&amp;subject=database&amp;{$misc->href}&amp;\"'>\n";

        if ($subact == "edit") {
            $idx = $cnt;
            if (isset($opid)) {
                for ($i = 1; $i < $cnt; $i ++) {
                    $j = $i - 1;
                    if ($tk['backupid'][$j] == $opid) {
                        $idx = $j;
                        break;
                    }
                }
            }
            if ($idx != $cnt) { // find backupid
                $in_opdir = $tk['path'][$idx];
                $in_periodtype = $tk['period_type'][$idx];
                $in_perioddate = $tk['period_date'][$idx];
                $in_time = $tk['time'][$idx];
                $in_level = $tk['level'][$idx];
                $in_archivedel = $tk['archivedel'][$idx];
                $in_updatestatus = $tk['updatestatus'][$idx];
                $in_storeold = $tk['storeold'][$idx];
                $in_onoff = $tk['onoff'][$idx];
                $in_zip = $tk['zip'][$idx];
                $in_check = $tk['check'][$idx];
                $in_mt = $tk['mt'][$idx];
            }
            else {
                $in_opdir = $_server_info['dbdir'][$db]."/backup";
                $in_periodtype = "Weekly";
                $in_perioddate = "1";
                $in_time = "0000";
                $in_level = "0";
                $in_archivedel = "OFF";
                $in_updatestatus = "OFF";
                $in_storeold = "OFF";
                $in_onoff = "ON";
                $in_zip = 'y';
                $in_check = 'y';
                $in_mt = 0;
            }
            echo "<form action=\"database.php\" method=\"post\" name='inform'>\n";
            echo "<input type=\"hidden\" name=\"action\" value=\"backupauto\" />\n";
            echo "<input type=\"hidden\" name=\"subact\" value=\"save\" />\n";
            echo "<input type=\"hidden\" name=\"opid\" value=\"$opid\" />\n";
            echo $misc->form;
            echo "<input type=\"hidden\" name=\"opdatabase\" value=\"", htmlspecialchars($db), "\" />\n";
            if ($idx == $cnt) // new
                echo "1. ".$lang['strbackupid']." <input type=text name='in_id' size='16' value=''><br>\n";
            else
                echo "1. ".$lang['strbackupid']." : $opid <br>\n";
            echo "2. ".$lang['strperiodtype']." <input type=text name='in_periodtype' size='16' value='{$in_periodtype}'> ".
                "(Monthly, Weekly, Daily, Special)<br>\n";
            echo "3. ".$lang['strperioddetail']." <input type=text name='in_perioddate' size='16' value='{$in_perioddate}'><br> ".
                "&nbsp;&nbsp;&nbsp;&nbsp;Monthly : 1-31, Daily : nothing, Special : YYYY-MM-DD<br>".
                "&nbsp;&nbsp;&nbsp;&nbsp;Weekly : Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday<br>\n";
            echo "4. ".$lang['strtime']." <input type=text name='in_time' size='4' value='{$in_time}'> HHMM ex) 0200<br>\n";
            echo "5. ".$lang['strbackuplevel']." ".$misc->radiomake(array("0","1","2"), $in_level, "in_level")."<br>\n";
            $onoffstr = array("OFF","ON");
            echo "6. ".$lang['strdeletearchive']." ".$misc->radiomake($onoffstr, $in_archivedel, "in_archivedel")."<br>\n";
            echo "7. ".$lang['strupdatestatistics']." ".$misc->radiomake($onoffstr, $in_updatestatus, "in_updatestatus")."<br>\n";
            echo "8. ".$lang['strstoreoldbackup']." ".$misc->radiomake($onoffstr, $in_storeold, "in_storeold")."<br>\n";
            echo "9. ".$lang['stronlinebackup']."/{$lang['strofflinebackup']} ".
                $misc->radiomake($onoffstr, $in_onoff, "in_onoff")."<br>\n";
            $ynstr = array("n","y");
            echo "10. ".$lang['strusecompress']." ".$misc->radiomake($ynstr, $in_zip, "in_zip")."<br>\n";
            echo "11. ".$lang['strchckingconsistency']." ".$misc->radiomake($ynstr, $in_check, "in_check")."<br>\n";
            echo "12. ".$lang['strreadthread']." <input type=text name='in_mt' size='3' value='{$in_mt}'> <br>\n";
            echo "13. ".$lang['strtargetdirectory']." <input type=text name='opdir' size='50' value='$in_opdir'>".
                " * Server<br>\n";
            echo "<input type=\"submit\" name=\"op\" value=\"{$lang['strsave']}\"  onclick=\"show_waiting();\"/>\n";
            echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
            echo "</form>\n";
        }
    }

    function doQueryauto($msg = "") {
        global $data, $misc, $db, $_server_info;
        global $lang, $subact, $double_token_to, $opid;

        $misc->printTrail('database');
        $misc->printTitle($lang['strqueryauto']);
        $misc->printMsg($msg);

        include_once "waiting.php";

        $tk = $misc->ManagerCommand($_server_info['id'], "getautoexecquery" , "dbname:$db");
        if ($tk['status'] != "success") {
            echo "<br>".$tk['note']."<br>";
            return;
        }
        else {
            if (!isset($tk['planlist'][0]['queryplan']) ||
                count($tk['planlist'][0]['queryplan']) <= 0) { 
                    echo "<br>".$lang['strnodata']."<br>";
                    $cnt = 0;
                }
            else {
                $querys = $tk['planlist'][0]['queryplan'];
                $cnt = count($querys);
                $col = array("query_id","period","detail","actions","query_string");
                $col = $misc->column_make($col);
                $dat = new ArrayRecordSet($querys);
                $act = array(
                    'edit' => array(
                        'title' => $lang['stredit'],
                        'url'   => "database.php?action=queryauto&amp;subact=edit&amp;subject=database&amp;{$misc->href}&amp;",
                        'vars'  => array('opid' => 'query_id'),
                    ),
                    'delete' => array(
                        'title' => $lang['strdelete'],
                        'url'   => "database.php?action=queryauto&amp;subact=del&amp;subject=database&amp;{$misc->href}&amp;",
                        'vars'  => array('opid' => 'query_id'),
                    ),
                );
                $misc->printTable($dat, $col, $act);
            }
        }
        echo "<input type=\"button\" value=\"{$lang['stradd']}\" ".
            "onclick='window.location=\"database.php?action=queryauto&amp;subact=edit&amp;subject=database&amp;{$misc->href}&amp;\"'>\n";

        if ($subact == "edit") {
            $idx = $cnt;
            if (isset($opid)) {
                for ($i = 0; $i < $cnt; $i ++) {
                    if ($querys[$i]['query_id'] == $opid) {
                        $idx = $i;
                        break;
                    }
                }
            }
            if ($idx != $cnt) { // find query_id
                $in_periodtype = $querys[$idx]['period'];
                list($in_perioddate, $in_time) = split(" ", $querys[$idx]['detail']);
                $in_time = substr($in_time, 0, 2).substr($in_time, 3);
                $in_querystring = $querys[$idx]['query_string'];
            }
            else {
                $in_periodtype = "MONTH";
                $in_perioddate = "1";
                $in_time = "0000";
                $in_querystring = "";
            }
            echo "<form action=\"database.php\" method=\"post\" name='inform'>\n";
            echo "<input type=\"hidden\" name=\"action\" value=\"queryauto\" />\n";
            echo "<input type=\"hidden\" name=\"subact\" value=\"save\" />\n";
            echo "<input type=\"hidden\" name=\"opid\" value=\"$opid\" />\n";
            echo $misc->form;
            echo "<input type=\"hidden\" name=\"opdatabase\" value=\"", htmlspecialchars($db), "\" />\n";
            if ($idx == $cnt) // new
                echo "1. ".$lang['strqueryid']." <input type=text name='in_id' size='16' value=''><br>\n";
            else
                echo "1. ".$lang['strqueryid']." : $opid <br>\n";
            echo "2. ".$lang['strperiodtype']." <input type=text name='in_periodtype' size='16' value='{$in_periodtype}'> ".
                "(MON, WEEK, DAY, ONE)<br>\n";
            echo "3. ".$lang['strperioddetail']." <input type=text name='in_perioddate' size='16' value='{$in_perioddate}'><br> ".
                "&nbsp;&nbsp;&nbsp;&nbsp;MON : 1-31, DAY : EVERYDAY, ONE : YYYY-MM-DD<br>".
                "&nbsp;&nbsp;&nbsp;&nbsp;WEEK : SUN, MON, TUE, WED, THU, FRI, SAT<br>\n";
            echo "4. ".$lang['strtime']." <input type=text name='in_time' size='4' value='{$in_time}'> HHMM ex) 0200<br>\n";
            echo "5. ".$lang['strquerystring']."<br>\n".
                "<textarea rows=6 cols=80 name=\"in_querystring\">$in_querystring</textarea><br>";
            echo "<input type=\"submit\" name=\"op\" value=\"{$lang['strsave']}\"  onclick=\"show_waiting();\"/>\n";
            echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
            echo "</form>\n";
        }
    }

    function doBackup() {
        global $data, $misc, $db, $_server_info;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strbackup']);

        include_once "waiting.php";

        echo "<p>", sprintf($lang['strconfdbop'], $lang['strbackup'], $misc->printVal($db)), "</p>\n";	

        $lvlmax = 0;
        $tk = $misc->ManagerCommand($_server_info['id'], "backupdbinfo" , "dbname:$db");
        if ($tk['status'] == "success" && isset($tk['level0'])) {
            echo $lang['strbackup']." ".$lang['strhistory']."<ul>";
            for ($i = 0; $i < 3; $i ++) {
                if (!isset($tk['level'.$i])) break;
                if ($i < 2) $lvlmax = $i + 1;
                $lvl = $tk['level'.$i][0];
                list($y1, $m1, $d1, $hh, $mm) = explode('.', $lvl['data']);
                echo "\t<li> LEVEL $i=$y1/$m1/$d1 $hh:$mm ".$lvl['path']."(".$lvl['size']." byte)</li>\n";
            }
            echo "</ul><br>\n";
        }

        $voltmp = $db."_backup_lv";
        echo "<form action=\"database.php\" method=\"post\" name='inform'>\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"backup\" />\n";
        echo $misc->form;
        echo "<input type=\"hidden\" name=\"opdatabase\" value=\"", htmlspecialchars($db), "\" />\n";
        echo "1. ".$lang['strtargetdirectory']." <input type=text name='opdir' size='50' value='{$tk['dbdir']}'>".
             " * Server<br>\n";
        echo "2. ".$lang['strvolumename']." <input type=text name='opvol' size='40' value='{$voltmp}0'> <br>\n";
        echo "3. Level 0 <input type='radio' name='opoption' value='0' checked onclick='document.inform.opvol.value=\"{$voltmp}0\"'> ";
        for ($i = 1; $i <= $lvlmax;  $i++) {
            echo "Level $i <input type='radio' name='opoption' value='$i' onclick='document.inform.opvol.value=\"{$voltmp}$i\"'> ";
        }
        echo "<br>\n";
        echo "4. {$lang['strarchivekeep']} <input type='radio' name='oplogdel' value='0' checked> ";
        echo "{$lang['strarchivedel']} <input type='radio' name='oplogdel' value='1'><br>\n";
        echo "<input type=\"submit\" name=\"op\" value=\"{$lang['strbackup']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }


    function doRestore() {
        global $data, $misc, $db, $_server_info;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strrestore']);

        include_once "waiting.php";

        echo "<p>", sprintf($lang['strconfdbop'], $lang['strrestore'], $misc->printVal($db)), "</p>\n";	

        echo "<form action=\"database.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"restore\" />\n";
        echo $misc->form;
        echo "<input type=\"hidden\" name=\"opdatabase\" value=\"", htmlspecialchars($db), "\" />\n";

        $tk = $misc->ManagerCommand($_server_info['id'], "backupdbinfo" , "dbname:$db");
        $cnt = 0;
        if ($tk['status'] == "success" && isset($tk['level0'])) {
            for ($i = 0; $i < 3; $i ++) {
                if (!isset($tk['level'.$i])) break;
                $lvl = $tk['level'.$i][0];
                list($y1, $m1, $d1, $hh, $mm) = explode('.', $lvl['data']);
                $chkstr = ($i == 0) ? "checked" : "";
                echo "LEVEL $i <input type='radio' name='opoption' value='".($i+1)."' $chkstr> ";
                echo "$y1/$m1/$d1 $hh:$mm ".$lvl['path']."(".$lvl['size']." byte)<br>\n";
                $cnt ++;
            }
        }
        if ($cnt <= 0) echo "No backup exist!!!<br>\n";
        echo "<br>\n";
        echo $lang['strgiventime']." <input type=text name='opdate' size='20'> YYYY-MM-DD HH:MM:SS<br>\n";
        echo " &nbsp;&nbsp;&nbsp;&nbsp;".$lang['strnogiventime']."<br>";
        echo "<input type=\"submit\" name=\"op\" value=\"{$lang['strrestore']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }

    function doLockinfo() {
        global $data, $misc, $db, $_server_info;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strlockinfo']);

        $tk = $misc->ManagerCommand($_server_info['id'], "lockdb" , "dbname:$db");
        if ($tk['status'] != "success" || !isset($tk['lockinfo'][0])) {
            echo "<br>".$tk['note']."<br>";
            return;
        }
        $lk = $tk['lockinfo'][0];
        echo "Lock escalation : ".$lk['esc']."<br>\n";
        echo "Run deadlock interval : ".$lk['dinterval']."<br>\n";
        $cnt = count($lk['transaction']);
        if ($cnt > 0) {
            echo "[".$lang['strconnectedclient']."]<br>\n";
            $col = $misc->column_make(array("index","pname","uid","host","pid","isolevel","timeout"));
            $dat = new ArrayRecordSet($lk['transaction']);
            $act = array();
            $misc->printTable($dat, $col, $act);
        }
        echo "<br>\n";

        $lot = $lk['lot'][0];

        echo $lang['strlockedobject']." : ".$lot['numlocked']."<br>\n";
        echo $lang['strmaxlockobject']." : ".$lot['maxnumlock']."<br>\n";
        if (isset($lot['entry'])) {
            $cnt = count($lot['entry']);
            if ($cnt > 0) {
                echo "[".$lang['strlockedobject']."]<br>\n";
                for ($i = 0; $i < $cnt; $i++) {
                    $tmpcnt = count($lot['entry'][$i]['lock_holders']);
                    $tmphold = "";
                    for ($j = 0; $j < $tmpcnt; $j ++) {
                        $tmphold .= $misc->array_implode($lot['entry'][$i]['lock_holders'][$j], "|");
                    }
                    $lot['entry'][$i]['lock_holders'] = $tmphold;
                }
                $col = $misc->column_make(array("oid","ob_type","num_holders","num_b_holders","num_waiters","lock_holders"));
                $dat = new ArrayRecordSet($lot['entry']);
                $act = array();
                $misc->printTable($dat, $col, $act);
            }
        }
        echo "<br>\n";

        echo "<input type=\"button\" value=\"{$lang['strrefresh']}\" ".
            "onclick='window.location=\"database.php?action=lockinfo&amp;subject=database&amp;{$misc->href}&amp;\"'>\n";
    }

    function doTransaction($killmsg) {
        global $data, $misc, $db, $_server_info;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strtransaction']);

        if ($killmsg != "") 
            $tk = $misc->ManagerCommand($_server_info['id'], "killtransaction" , $killmsg);
        else
            $tk = $misc->ManagerCommand($_server_info['id'], "gettransactioninfo" , "dbname:$db");
        if ($tk['status'] != "success") {
            echo "<br>".$tk['note']."<br>";
            return;
        }
        if (isset($tk['transactioninfo'][0]['transaction'])) {
            $cnt = count($tk['transactioninfo'][0]['transaction']);
            if ($cnt > 0) {
                echo "[".$lang['strtransaction']."]<br>\n";
                $col = $misc->column_make(array("tranindex","user","host","pid","program"));
                $col['actions']=array('title' => $lang['strkilltran']);
                $dat = new ArrayRecordSet($tk['transactioninfo'][0]['transaction']); 
                $act = array(
                    'killtran' => array(
                        'title' => $lang['strkilltranthisonly'],
                        'url'   => "database.php?action=killtran&atype=idx&amp;subject=database&amp;{$misc->href}&amp;",
                        'vars'  => array('opvar' => 'tranindex'),
                    ),
                    'killtranuser' => array(
                        'title' => $lang['strkilltranuser'],
                        'url'   => "database.php?action=killtran&atype=user&amp;subject=database&amp;{$misc->href}&amp;",
                        'vars'  => array('opvar' => 'user'),
                    ),
                    'killtranhost' => array(
                        'title' => $lang['strkilltranhost'],
                        'url'   => "database.php?action=killtran&atype=host&amp;subject=database&amp;{$misc->href}&amp;",
                        'vars'  => array('opvar' => 'host'),
                    ),
                    'killtranpgm' => array(
                        'title' => $lang['strkilltranpgm'],
                        'url'   => "database.php?action=killtran&atype=pgm&amp;subject=database&amp;{$misc->href}&amp;",
                        'vars'  => array('opvar' => 'program'),
                    ),
                );
                $misc->printTable($dat, $col, $act);
            }
        }
        echo "<br>\n";

        echo "<input type=\"button\" value=\"{$lang['strrefresh']}\" ".
            "onclick='window.location=\"database.php?action=transaction&amp;subject=database&amp;{$misc->href}&amp;\"'>\n";
    }


    function doParameter($paraact) {
        global $data, $misc, $db, $_server_info;
        global $lang;

        $misc->printTrail('database');
        $misc->printTitle($lang['strparadb']);

        include_once "waiting.php";
        if ($paraact == "")
            $tk = $misc->ManagerCommand($_server_info['id'], "getallsysparam" , "dbname:$db");
        else
            $tk = $misc->ManagerCommand($_server_info['id'], "setsysparam" , $paraact);
        if ($tk['status'] != "success" || !isset($tk['paramlist'][0]['entry'])) {
            echo "<br>".$tk['note']."<br>";
            return;
        }
        if ($paraact != "")
            $misc->printMsg($lang['strdatabaseopsuccess']);

        echo "<form name='paraform' action=\"database.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"parachg\" />\n";
        echo "<input type=\"hidden\" name=\"paraname\" value=\"\" />\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "<table border=0 width=100%>\n";
        echo $misc->form;
       
        include_once "sqlxpara.php";
        echo "<tr><th class=data>Name</th><th class=data>Value</th><th class=data>Action</th><th class=data>TYPE|C/S</th>";
        echo "<th class=data>Default</th><th class=data>MIN</th><th class=data>MAX</th></tr>\n";

        $paras = $tk['paramlist'][0]['entry'];
        for ($i = 0; $i < count($paras); $i ++) {
            $pname = $paras[$i]['name'];
            $pvalu = $paras[$i]['value'];
            $ppara = $sqlxpara[$pname];
            $cls = ($i % 2 ==0) ? "class=data1" : "class=data2";
            if ($ppara[0] != $tString && $ppara[0]!=$tIsolation) { // value adjust
                $pvalu += 0;
            }
            echo "<tr><td align=left $cls>$pname</td>";
            echo "<td $cls><input type='text' name='sqlx_$pname' value='$pvalu' size=30></td>";
            echo "<td $cls><input type=button value='{$lang['strsave']}' onclick='para_waiting(\"$pname\")'>";
            echo $misc->help("help".$pname, $ppara[4],0,0)."</td>\n";
            echo "<td $cls>".$tTypeStr[$ppara[0]]."|".$uTypeStr[$ppara[5]]."</td>\n";
            echo "<td $cls>{$ppara[1]}</td><td $cls>{$ppara[2]}</td><td $cls>{$ppara[3]}</td></tr>\n";
        }
        echo "</table>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }

  
    function doDefault($msg = '') {
        global $data, $conf, $misc, $_server_info, $db;
        global $lang, $action, $viewlog, $log_start_line;

        $misc->printTrail('database');
        $misc->printTabs('database','database');
        $misc->printMsg($msg);


        $columns = array(
            'title' => array(
                'title' => $lang['strfield'],
                'field' => 'title',
            ),
            'content' => array(
                'title' => $lang['strcontent'],
                'field' => 'content',
            ),
        );

        $contents = array(
            array(
                'title' => $lang['strlogin'],
                'content' => $_server_info['login'][$db],
            ),
            array(
                'title' => $lang['strisdba'],
                'content' => $_server_info['isdba'][$db],
            ),
            array(
                'title' => $lang['strpagesize'],
                'content' => $_server_info['pagesize'][$db],
            ),
            array(
                'title' => $lang['strstatus'],
                'content' => $_server_info['dbstat'][$db],
            ),
        );

        $datrows = new ArrayRecordSet($contents);
        $actions = array();
        $misc->printTable($datrows, $columns, $actions);

        if (isset($_server_info['spaceinfo'][$db])) {
            $spi = $_server_info['spaceinfo'][$db];
            for ($j = 0; $j < count($spi); $j++) {
                if ($spi[$j]['type'] == "Active_log" || 
                    $spi[$j]['type'] == "Archive_log") {
                        $spi[$j]['freepage'] = "";
                    }
                else 
                    $spi[$j]['freepage'] = $spi[$j]['freepage']."(".($spi[$j]['freepage'] * $_server_info['pagesize'][$db]/1024000)."MB)";
                $spi[$j]['totalpage'] = $spi[$j]['totalpage']."(".($spi[$j]['totalpage'] * $_server_info['pagesize'][$db]/1024000)."MB)";
            }

            $datrows = new ArrayRecordSet($spi);

            $columns = array(
                'spacename' => array(
                    'title' => $lang['strvolume'],
                    'field' => 'spacename',
                ),
                'type' => array(
                    'title' => $lang['strtype'],
                    'field' => 'type',
                ),
                'freepage' => array(
                    'title' => $lang['strfreespace'],
                    'field' => 'freepage',
                ),
                'totalpage' => array(
                    'title' => $lang['strtotalspace'],
                    'field' => 'totalpage',
                ),
            );
            $misc->printTable($datrows, $columns, $actions);
        }

        include_once "waiting.php";

        echo "<br><ul>\n";

        if ($_server_info['isdba'][$db] == 'y') {
            if ($_server_info['dbstat'][$db] == 'start') {
                echo "\t<li><a href=\"all_db.php?action=stopdb&amp;subject=database&amp;{$misc->href}&amp;\"".
                    " onclick=\"show_waiting();\">{$lang['strstopdb']}</a></li>\n";
                echo "\t<li><a href=\"all_db.php?action=restartdb&amp;subject=database&amp;{$misc->href}&amp;\"".
                    " onclick=\"show_waiting();\">{$lang['strrestartdb']}</a></li>\n";
                echo "\t<li><a href=\"database.php?action=lockinfo&amp;subject=database&amp;{$misc->href}&amp;\"".
                    " onclick=\"show_waiting();\">{$lang['strlockinfo']}</a></li>\n";
                echo "\t<li><a href=\"database.php?action=transaction&amp;subject=database&amp;{$misc->href}&amp;\"".
                    " onclick=\"show_waiting();\">{$lang['strtransaction']}</a></li>\n";
                echo "\t<li><a href=\"database.php?action=backupauto&amp;subject=database&amp;".
                    "{$misc->href}&amp;\">{$lang['strbackupauto']}</a></li>\n";
                echo "\t<li><a href=\"database.php?action=queryauto&amp;subject=database&amp;".
                    "{$misc->href}&amp;\">{$lang['strqueryauto']}</a></li>\n";
                echo "\t<li><a href=\"database.php?action=autovoladd&amp;subject=database&amp;".
                    "{$misc->href}&amp;\">{$lang['strvolumeautoadd']}</a></li>\n";
            }
            else {
                echo "\t<li><a href=\"all_db.php?action=startdb&amp;subject=database&amp;{$misc->href}&amp;\"".
                    " onclick=\"show_waiting();\">{$lang['strstartdb']}</a></li>\n";
                echo "\t<li><a href=\"database.php?action=confirm_drop&amp;subject=database&amp;".
                    "{$misc->href}&amp;\">{$lang['strdrop']}</a></li>\n";
                echo "\t<li><a href=\"database.php?action=confirm_alter&amp;subject=database&amp;".
                    "{$misc->href}&amp;\">{$lang['stralter']}</a></li>\n";
                if ($_server_info['dbsuper']=="admin")
                    echo "\t<li><a href=\"database.php?action=confirm_copy&amp;subject=database&amp;".
                        "{$misc->href}&amp;\">{$lang['strcopydb']}</a></li>\n";
                echo "\t<li><a href=\"database.php?action=confirm_load&amp;subject=database&amp;".
                    "{$misc->href}&amp;\">{$lang['strloaddb']}</a></li>\n";
                echo "\t<li><a href=\"database.php?action=confirm_restore&amp;subject=database&amp;".
                    "{$misc->href}&amp;\">{$lang['strrestore']}</a></li>\n";
                echo "\t<li><input type='button' value='".$lang['strcompact']."' onclick='confirm_url_waiting(\"".
                    sprintf($lang['strconfdbop'], $lang['strcompact'],$db)."\", \"database.php?".
                    "action=compactdb&amp;subject=database&amp;{$misc->href}&amp;\")'></li>\n";
            }
            //@@@
            echo "\t<li><a href=\"database.php?action=voladd&amp;subject=database&amp;".
                "{$misc->href}&amp;\">{$lang['strvolumeadd']}</a></li>\n";
            echo "\t<li><a href=\"database.php?action=confirm_unload&amp;subject=database&amp;".
                "{$misc->href}&amp;\">{$lang['strunloaddb']}</a></li>\n";
            echo "\t<li><a href=\"database.php?action=confirm_backup&amp;subject=database&amp;".
                "{$misc->href}&amp;\">{$lang['strbackup']}</a></li>\n";
            echo "\t<li><a href=\"database.php?action=confirm_para&amp;subject=database&amp;".
                "{$misc->href}&amp;\">{$lang['strparadb']}</a></li>\n";
            echo "\t<li><input type='button' value='".$lang['stroptimize']."' onclick='confirm_url_waiting(\"".
                sprintf($lang['strconfdbop'], $lang['stroptimize'],$db)."\", \"database.php?".
                "action=optimizedb&amp;subject=database&amp;{$misc->href}&amp;\")'></li>\n";
            echo "\t<li><input type='button' value='".$lang['strcheck']."' onclick='confirm_url_waiting(\"".
                sprintf($lang['strconfdbop'], $lang['strcheck'],$db)."\", \"database.php?".
                "action=checkdb&amp;subject=database&amp;{$misc->href}&amp;\")'></li>\n";
        }

        echo "</ul>\n";

        $tk = $misc->ManagerCommand($_server_info['id'], "getloginfo" , "dbname:$db\n");
        if ($tk['status']!="success") {
            echo $lang['logreadfail']." ".$tk['note'];
        }
        else if (isset($tk['loginfo'][0]['log'])) {
            $cnt = count($tk['loginfo'][0]['log']);
            $loginfo = $tk['loginfo'][0]['log'];
            if ($cnt > 0) {
                echo "<br>[Database logs]<ul>\n";
                if (get_magic_quotes_gpc())
                    $viewlog = stripslashes($viewlog);
                for ($i=0; $i < $cnt; $i++) {
                    echo "\t<li>";
                    $urllogpath = urlencode($loginfo[$i]['path']);
                    if ($loginfo[$i]['size']>0)
                        echo "<a href=\"database.php?action=viewlog&amp;viewlog=$urllogpath&amp;log_start_line=0".
                            "&amp;subject=database&amp;{$misc->href}&amp;\" onclick=\"show_waiting();\">";
                    echo $loginfo[$i]['path']."(";
                    echo $loginfo[$i]['size']." byte(s)/";
                    echo $loginfo[$i]['lastupdate'].") ";
                    if ($loginfo[$i]['size']>0) echo "</a>";
                    if ($_server_info['isdba'][$db] == 'y') {
                        echo "<input type='button' value='".$lang['strdeletelog']."' onclick='confirm_url(\"".
                            $lang['strconfdeletelog']."\", \"database.php?".
                            "action=resetlog&amp;logpath=$urllogpath&amp;subject=database&amp;{$misc->href}&amp;\")'>";
                    }
                    echo "</li>\n";
                    if (isset($action) && $action == "viewlog" && $viewlog == $loginfo[$i]['path']) {
                        include_once('./libraries/viewlog.inc.php');
                        manager_viewlog($loginfo[$i]['path'],
                            "database.php?action=viewlog&amp;viewlog=$urllogpath&amp;subject=database&amp;{$misc->href}&amp;",
                            $log_start_line);
                    }
                }
                echo "</ul>\n";
            }
        }
    }


	function doTree() {
		global $misc, $lang;

		$reqvars = $misc->getRequestVars('database');

		$tabs = $misc->getNavTabs('database');

		$items = $misc->adjustTabsForTree($tabs);
		
		$attrs = array(
			'text'   => noEscape(field('title')),
			'icon'   => field('icon'),
			'action' => url(field('url'),
							$reqvars,
							field('urlvars', array())
						),
			'branch' => url(field('url'),
							$reqvars,
							field('urlvars'),
							array('action' => 'tree')
						),
		);
		
		$misc->printTreeXML($items, $attrs);

		exit;
	}

	if ($action == 'tree') doTree();
	
	$misc->printHeader($lang['strschemas'], "<script type=\"text/javascript\" src=\"tools.js\"></script>");
	$misc->printBody();

    switch ($action) {
    case 'unload':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        $requestMsg = "dbname:$opdatabase\n";
        if (get_magic_quotes_gpc())
            $opdir = stripslashes($opdir);
        $requestMsg .= "targetdir:$opdir\n";
        $requestMsg .= "usehash:no\n";
        $requestMsg .= "hashdir:none\n";
        if ($opoption == "0")
            $requestMsg .= "target:schema\n";
        else if ($opoption == "1")
            $requestMsg .= "target:object\n";
        else 
            $requestMsg .= "target:both\n";
        $cnt = 0;
        if (strlen(trim($optbls)) > 0) {
            $requestMsg .= "open:class\n";
            $tbls = split("[\n\r\t, ]+", $optbls);
            for ($i = 0; $i < count($tbls); $i ++) {
                $tbl = trim($tbls[$i]);
                if (strlen($tbl) <= 0) continue;
                $requestMsg .= "classname:$tbl\n";
                $cnt ++;
            }
            $requestMsg .= "close:class\n";
        }
        $requestMsg .= "ref:no\n";
        if ($cnt > 0)
            $requestMsg .= "classonly:yes\n";
        else
            $requestMsg .= "classonly:no\n";
        $requestMsg .= "delimit:no\n";
        $requestMsg .= "estimate:none\n";

        if (strlen(trim($opprefix)) > 0) 
            $requestMsg .= "prefix:".trim($opprefix)."\n";
        else 
            $requestMsg .= "prefix:none\n";
        $requestMsg .= "cach:none\n";
        $requestMsg .= "lofile:none\n";

        $tk = $misc->ManagerCommand($_server_info['id'], "unloaddb" , $requestMsg);
        if ($tk['status']!="success")
            doDefault($lang['strdatabaseopfailed']."\n".$tk['note']);
        else {     
            $cnt = count($tk['result'][0]);
            $rstmsg = " ";
            foreach ($tk['result'][0] as $tbl => $stat) {
                $rstmsg .= "<br>\n".$tbl."=>".$stat;
            }
            doDefault($lang['strdatabaseopsuccess'].$rstmsg);
        }
        break;

    case 'load':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        if (get_magic_quotes_gpc()) {
            $opschema = stripslashes(trim($opschema));
            $opdata = stripslashes(trim($opdata));
            $opindex = stripslashes(trim($opindex));
            $optrigger = stripslashes(trim($optrigger));
        }
        if (strlen($opschema) <= 0 &&
            strlen($opdata) <= 0 &&
            strlen($opindex) <= 0 &&
            strlen($optrigger) <= 0) {
                doDefault();
                break;
            }
        $requestMsg = "dbname:$opdatabase\n";
        if ($opoption == "0")
            $requestMsg .= "checkoption:load\n";
        else if ($opoption == "1")
            $requestMsg .= "checkoption:check\n";
        else 
            $requestMsg .= "checkoption:both\n";
        $requestMsg .= "period:none\n";
        $requestMsg .= "user:{$_server_info['login'][$db]}\n";
        $requestMsg .= "estimate:none\n";
        $requestMsg .= "oiduse:yes\n";
        $requestMsg .= "nolog:no\n";
        $reqsave = $requestMsg;

        if (strlen($opschema) <= 0)
            $requestMsg .= "schema:none\n";
        else
            $requestMsg .= "schema:$opschema\n";
        if (strlen($opdata) <= 0)
            $requestMsg .= "object:none\n";
        else
            $requestMsg .= "object:$opdata\n";
        if (strlen($opindex) <= 0)
            $requestMsg .= "index:none\n";
        else
            $requestMsg .= "index:$opindex\n";

        $tk = $misc->ManagerCommand($_server_info['id'], "loaddb" , $requestMsg);
        if ($tk['status']!="success")
            doDefault($lang['strdatabaseopfailed']."\n".$tk['note']);
        else {     
            if (strlen($optrigger) > 0) {
                $reqsave .= "schema:$optrigger\nobject:none\nindex:none\n";
                $tk2 = $misc->ManagerCommand($_server_info['id'], "loaddb" , $reqsave);
                if ($tk2['status']!="success") {
                    doDefault($lang['strdatabaseopfailed']."\n".$tk2['note']);
                    break;
                }
                $tk['line'].=$tk2['line'];
            }
            $rstmsg=nl2br($tk['line']);
            doDefault($rstmsg);
        }
        break;

    case 'backup':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        if (get_magic_quotes_gpc()) {
            $opdir = stripslashes(trim($opdir));
        }
        $requestMsg = "dbname:$opdatabase\n";
        $requestMsg .= "level:$opoption\n";
        $requestMsg .= "volname:$opvol\n";
        $requestMsg .= "backupdir:$opdir\n";
        if ($oplogdel == "1")
            $requestMsg .= "removelog:y\n";
        else
            $requestMsg .= "removelog:n\n";
        $requestMsg .= "check:y\n";
        $requestMsg .= "mt:0\n";
        $requestMsg .= "zip:y\n";

        $tk = $misc->ManagerCommand($_server_info['id'], "backupdb" , $requestMsg);
        if ($tk['status']!="success")
            doDefault($lang['strdatabaseopfailed']."\n".$tk['note']);
        else      
            doDefault($lang['strdatabaseopsuccess']);
        break;

    case 'restore':
        if (isset($_POST['cancel']) ||
            !isset($opoption) || ($opoption+0) <= 0) {
                doDefault();
                break;
            }
        $requestMsg = "dbname:$opdatabase\n";
        $datary = split("[-: ]+", $opdate);
        $year=0; $month=0; $day=0; $hh=0; $mm=0; $ss=0;
        if (count($datary) == 6) {
            $year+=$datary[0]; 
            $month+=$datary[1]; 
            $day+=$datary[2]; 
            $hh+=$datary[3]; 
            $mm+=$datary[4]; 
            $ss+=$datary[5];
        }
        if ($year >= 1900 && $year <= 2100 &&
            $month >= 1 && $month <= 12 &&
            $day >= 1 && $day <= 31 &&
            $hh >= 0 && $hh <=23 &&
            $mm >= 0 && $mm <=59 &&
            $ss >=0 && $ss <= 59)
            $requestMsg .= "date:$day-$month-$year:$hh:$mm:$ss\n";
        else
            $requestMsg .= "date:none\n";
        $opoption -= 1;
        $requestMsg .= "level:$opoption\n";
        $requestMsg .= "partial:y\n";
        $requestMsg .= "pathname:none\n";

        $tk = $misc->ManagerCommand($_server_info['id'], "restoredb" , $requestMsg);
        if ($tk['status']!="success")
            doDefault($lang['strdatabaseopfailed']."\n".$tk['note']);
        else      
            doDefault($lang['strdatabaseopsuccess']);
        break;

    case 'compactdb':
        $tk = $misc->ManagerCommand($_server_info['id'], "compactdb" , "dbname:$db");
        if ($tk['status']!="success")
            doDefault($lang['strdatabaseopfailed']."\n".$tk['note']);
        else      
            doDefault($lang['strdatabaseopsuccess']);
        break;

    case 'optimizedb':
        $tk = $misc->ManagerCommand($_server_info['id'], "optimizedb" , "dbname:$db");
        if ($tk['status']!="success")
            doDefault($lang['strdatabaseopfailed']."\n".$tk['note']);
        else      
            doDefault($lang['strdatabaseopsuccess']);
        break;

    case 'checkdb':
        $tk = $misc->ManagerCommand($_server_info['id'], "checkdb" , "dbname:$db");
        if ($tk['status']!="success")
            doDefault($lang['strdatabaseopfailed']."\n".$tk['note']);
        else      
            doDefault($lang['strdatabaseopsuccess']);
        break;

    case 'confirm_load':
        doLoad();
        break;
    case 'confirm_unload':
        doUnload();
        break;
    case 'confirm_backup':
        doBackup();
        break;
    case 'confirm_restore':
        doRestore();
        break;
    case 'confirm_drop':
        doDrop();
        break;
    case 'confirm_alter':
        doAlter();
        break;
    case 'confirm_copy':
        doCopy();
        break;
    case 'backupauto':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        if (!isset($subact)) $subact = "list";
        if ($subact == "del" && isset($opid)) {
            $tk = $misc->ManagerCommand($_server_info['id'], "deletebackupinfo" , 
                "dbname:$db\nbackupid:$opid\n");
            if ($tk['status']!="success") {
                doBackupauto($tk['note']);
                break;
            }
        }
        else if ($subact == "save") {
            if (!isset($in_id)) $in_id = $opid;
            $msg ="dbname:$db\n";
            $msg .="backupid:$in_id\n";
            if (get_magic_quotes_gpc())
                $opdir = stripslashes($opdir);
            $msg .="path:$opdir\n";
            $msg .="period_type:$in_periodtype\n";
            $msg .="period_date:$in_perioddate\n";
            $msg .="time:$in_time\n";
            $msg .="level:$in_level\n";
            $msg .="archivedel:$in_archivedel\n";
            $msg .="updatestatus:$in_updatestatus\n";
            $msg .="storeold:$in_storeold\n";
            $msg .="onoff:$in_onoff\n";
            $msg .="zip:$in_zip\n";
            $msg .="check:$in_check\n";
            $msg .="mt:$in_mt\n";
            $cmd = ($in_id == $opid) ? "setbackupinfo" : "addbackupinfo";
            $tk = $misc->ManagerCommand($_server_info['id'], $cmd, $msg);
            if ($tk['status']!="success") {
                doBackupauto($tk['note']);
                break;
            }
        }
        doBackupauto();
        break;

    case 'queryauto':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        if (!isset($subact)) $subact = "list";
        if ($subact == "del" || $subact == "save") {
            if ($subact == "save") {
                if (!isset($in_id)) $in_id = $opid;
                $in_time = substr($in_time, 0, 2).":".substr($in_time, 2);
                $newrec = array (
                    "query_id" => $in_id,
                    "period" => $in_periodtype,
                    "detail" => $in_perioddate." ".$in_time,
                    "query_string" => $in_querystring );
            }
            $tk = $misc->ManagerCommand($_server_info['id'], "getautoexecquery" , "dbname:$db");
            if ($tk['status'] == "success" &&
                isset($tk['planlist'][0]['queryplan']) &&
                count($tk['planlist'][0]['queryplan']) > 0) { 
                    $querys = $tk['planlist'][0]['queryplan'];
                    $cnt = count($querys);
                    if ($subact == "save" && $opid != $in_id) 
                        $querys[]=$newrec;
                    else {
                        for ($i = 0; $i < $cnt; $i++) {
                            if ($querys[$i]['query_id']==$opid) {
                                if ($subact == "save")
                                    $querys[$i]=$newrec;
                                else {
                                    unset($querys[$i]);
                                    $cnt --;
                                }
                                break;
                            }
                        }
                    }
                }
            else {
                $cnt = 0;
                if ($subact == "save") {
                    $querys=array();
                    $querys[]=$newrec;
                }
            }

            $msg ="dbname:$db\n"."open:planlist\n";
            foreach ($querys as $idx => $rec) {
                $msg .= "open:queryplan\n";
                $msg .= "query_id:{$rec['query_id']}\n";
                $msg .= "period:{$rec['period']}\n";
                $msg .= "detail:{$rec['detail']}\n";
                $rec['query_string'] = preg_replace("(\r\n|\n|\r)", " ", $rec['query_string']);
                $msg .= "query_string:{$rec['query_string']}\n";
                $msg .= "close:queryplan\n";
            }
            $msg .= "close:planlist\n";
            $tk = $misc->ManagerCommand($_server_info['id'], "setautoexecquery", $msg);
            if ($tk['status']!="success") {
                doQueryauto($tk['note']);
                break;
            }
        }
        doQueryauto();
        break;

    case 'parachg':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        if (isset($paraname)) {
            $msg = "dbname:$db\n";
            $msg .= "param:$paraname\n";
            $tmpvar="sqlx_$paraname";
            $msg .= "paramval:".$$tmpvar."\n";
            doParameter($msg);
            break;
        }
    case 'autovoladd':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        else if (isset($_POST['voladd'])) {
            $msg="dbname:$db\n";
            $msg .= "data:$in_data\n";
            $msg .="data_warn_outofspace:$in_datawarn\n";
            $msg .= "data_ext_page:$in_datapage\n";
            $msg .= "index:$in_index\n";
            $msg .= "index_warn_outofspace:$in_indexwarn\n";
            $msg .= "index_ext_page:$in_indexpage";
            $tk = $misc->ManagerCommand($_server_info['id'], "setautoaddvol", $msg);
            if ($tk['status']!="success") 
                doAutovoladd($lang['strdatabaseopfailed']."\n".$tk['note']);
            else      
                doAutovoladd($lang['strdatabaseopsuccess']);
            break;
        }
        doAutovoladd("");
        break;
    case 'voladd':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        else if (isset($_POST['voladd'])) {
            $msg="dbname:$db\n";
            $msg .= "volname:\n";
            $msg .= "purpose:$add_type\n";
            if (get_magic_quotes_gpc())
                $opdir = stripslashes($opdir);
            $msg .= "path:$opdir\n";
            $msg .= "numberofpages:$in_datapage\n";
			$mb = (int)($in_datapage * $_server_info['pagesize'][$db] / 1024000);
            $msg .= "size_need_mb:$mb\n";
            $tk = $misc->ManagerCommand($_server_info['id'], "addvoldb", $msg);
            if ($tk['status']!="success") 
                doDefault($lang['strdatabaseopfailed']."\n".$tk['note']);
            else {     
                $misc->DBSpaceupdate($_server_info, $db);
                $_server_info = $misc->getServerInfo();
                doDefault($lang['strdatabaseopsuccess']);
            }
            break;
        }
        doVoladd("");
        break;
    case 'confirm_para':
        doParameter("");
        break;
    case 'lockinfo':
        doLockinfo();
        break;
    case 'killtran':
        $msg = "dbname:$db\n";
        switch ($atype) {
        case 'idx':
            $msg .= "type:t\n";
            $msg .= "parameter:$opvar\n";
            break;
        case 'user':
            $msg .= "type:u\n";
            $msg .= "parameter:$opvar\n";
            break;
        case 'host':
            $msg .= "type:h\n";
            $msg .= "parameter:$opvar\n";
            break;
        case 'pgm':
            $msg .= "type:pg\n";
            $msg .= "parameter:$opvar\n";
            break;
        }
        doTransaction($msg);
        break;
    case 'transaction':
        doTransaction("");
        break;
    case 'resetlog':
        if ($_server_info['isdba'][$db] == 'y') {
            $logpath = urldecode($logpath);
            if (get_magic_quotes_gpc())
                $logpath = stripslashes($logpath);
            $tk = $misc->ManagerCommand($_server_info['id'], "removelog" , 
                "open:files\npath:$logpath\nclose:files\n");
            if ($tk['status']!="success") {
                doDefault($tk['note']);
                break;
            }
        }
    default:
        doDefault();
        break;
    }

	$misc->printFooter();

?>
