<?php
  include_once('./classes/ArrayRecordSet.php');

	/**
	 * List app server in a broker
	 *
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');
    $brokers = $_server_info['brokers'];
    for ($i = 0; $i < count($brokers); $i++) {
        if ($brokers[$i]['name'] == $_REQUEST['broker']) break;
    }
    if ($i >= count($brokers) ||
        !isset($brokers[$i]['state']))
        $broker_info['state'] = 'OFF';
    else
        $broker_info = $brokers[$i];

	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';

    function setEnv() {
        global $data, $misc, $_server_info;
        global $lang, $broker;

        $misc->printTrail('broker');
        $misc->printTabs('broker','appserver');
        $misc->printTitle("SOURCE_ENV ".$lang['strparadb']);

        include_once "waiting.php";

        $tk = $misc->ManagerCommand($_server_info['id'], "getbrokerenvinfo" , "bname:$broker");
        if ($tk['status'] != "success") {
            echo "<br>".$tk['note']."<br>";
            return;
        }
        $envmsg = "";
        foreach ($tk as $key=>$val) {
            if ($key == 'task' ||
                $key == 'status' ||
                $key == 'note') continue;
            $envmsg .= $key."=".$val."\n";
        }
        echo "<form action=\"broker.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"setenv\" />\n";
        echo $misc->form;
        echo "<input type=\"hidden\" name=\"broker\" value=\"", htmlspecialchars($broker), "\" />\n";
        echo "<textarea name='in_var' cols=80 rows=10>$envmsg</textarea><br>\n";
        echo $lang['strtipsourceenv']."<br>\n";
        echo "<input type=\"submit\" name=\"setenv\" value=\"SOURCE_ENV {$lang['strparadb']}\" onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }


    function setPara() {
        global $data, $misc, $broker, $_server_info;
        global $lang;

        $misc->printTrail('broker');
        $misc->printTabs('broker','appserver');
        $misc->printTitle($lang['strparadb']);

        include_once "waiting.php";

        $brk = $misc->ManagerCommand($_server_info['id'], "getbrokerinfo" , "bname:$broker");
        if ($brk['status'] != "success") {
            echo "<br>".$brk['note']."<br>";
            return;
        }
        $paracnt = 0;
        foreach ($brk as $bkey=>$bval) {
            if ($bkey == 'task' ||
                $bkey == 'status' ||
                $bkey == 'note' ||
                $bkey == 'MASTER_SHM_ID' ||
                $bkey == 'bname' ||
                $bkey == 'APPL_SERVER' ||
                $bkey == '%') continue;
            $para_name[]=$bkey;
            $para_val[]=$bval;
            $paracnt ++;
        }
        $tk = $misc->ManagerCommand($_server_info['id'], "getaddbrokerinfo" , "");
        if ($tk['status'] != "success") {
            echo "<br>".$tk['note']."<br>";
            return;
        }
        if (!isset($tk['info']))
            $cnt = 0;
        else
            $cnt = count($tk['info']);
        $inuse_ports = "";
        $comm_port = 30000;
        for ($i = 0; $i < $cnt; $i ++) {
            $inuse_ports .= $tk['info'][$i]['bname']."(".$tk['info'][$i]['port'].") ";
            if ($tk['info'][$i]['port'] > $comm_port) 
                $comm_port = $tk['info'][$i]['port'];
        }
        $comm_port += 1000;

        echo "<form action=\"broker.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"setpara\" />\n";
        echo "<input type=\"hidden\" name=\"broker\" value=\"$broker\" />\n";
        echo "<input type=\"hidden\" name=\"PARA_APPL_SERVER\" value=\"{$brk['APPL_SERVER']}\" />\n";
        echo "<table border=0>\n";
        echo $misc->form;

        echo "<tr><th class=data>Name</th><th class=data>Value</th><th class=data>Help</th></tr>\n";

        for ($i = 0; $i < $paracnt; $i ++) {
            $cls = ($i % 2 ==0) ? "class=data1" : "class=data2";
            echo "<tr><td align=left $cls>{$para_name[$i]}</td>";
            $itemname = 'PARA_'.$para_name[$i];
            echo "<td $cls><input type='text' name='{$itemname}' value='{$para_val[$i]}' size=30></td>";
            if (isset($lang[$itemname])) 
                echo "<td $cls>".$misc->help("help".$para_name[$i], $lang[$itemname],0,0)."</td>\n";
            else
                echo "<td $cls>&nbsp;</td>\n";
            echo "</tr>\n";
        }
        echo "</table>\n";

        echo "<input type=\"submit\" name=\"setpara\" value=\"{$lang['strparadb']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }


	/**
	 * Show default list of columns in the table
	 */
    function doDefault($msg = '', $refresh = FALSE) {
        global $conf, $misc, $_server_info, $broker_info;
        global $lang, $action, $viewlog, $log_start_line, $broker;

        $misc->printTrail('broker');
        $misc->printTabs('broker','appserver');
        if ($broker_info['state'] == 'ON') {
            //$attrs = $misc->getBroker($_REQUEST['broker'], $refresh);
            $attrs = $misc->getBroker($_REQUEST['broker'], TRUE); // everytime refresh

            $title = $lang['strappserver'].':'.$attrs['asnum'].'(MIN:'.$attrs['minas'].', MAX:'.$attrs['maxas'].')';
            $broker_info['asnum'] = $attrs['asnum'];
            $broker_info['minas'] = $attrs['minas'];
            $broker_info['maxas'] = $attrs['maxas'];
            unset($attrs['asnum']);
            unset($attrs['minas']);
            unset($attrs['maxas']);
            $misc->printTitle($_server_info['UNICASVER']." ".$title,'');
            $misc->printMsg($msg);

            $columns = array(
                'appserver' => array(
                    'title' => $lang['strappserver'],
                    'field' => 'as_id',
                ),
                'status' => array(
                    'title' => $lang['strstatus'],
                    'field' => 'as_status',
                ),
                'process' => array(
                    'title' => $lang['strprocess'],
                    'field' => 'as_pid',
                ),
                'request' => array(
                    'title' => $lang['strrequest'],
                    'field' => 'as_c',
                ),
                'psize' => array(
                    'title' => $lang['strpsize'],
                    'field' => 'as_psize',
                ),
                'lastaccess' => array(
                    'title' => $lang['strlastaccess'],
                    'field' => 'as_lat',
                ),
                'jobinfo' => array(
                    'title' => $lang['strjobinfo'],
                    'field' => 'as_cur',
                ),
                'actions' => array(
                    'title' => $lang['stractions'],
                )
            );

            $broker_href = "&amp;broker=".urlencode($_REQUEST['broker']);
            $actions = array(
                'aprestart' => array(
                    'title' => $lang['strrestartdb'],
                    'url'   => "broker.php?subject=broker$broker_href&amp;action=aprestart&amp;{$misc->href}&amp;",
                    'vars'  => array('as_id' => 'as_id'),
                ),
            );

            $datrows = new ArrayRecordSet($attrs);
            $misc->printTable($datrows, $columns, $actions);

            echo "<br />\n";
        }

        echo "<ul>\n";
        if ($_server_info['cassuper'] == "admin") {
            if ($broker_info['auto'] != 'ON'  && $broker_info['state'] == 'ON') {
                if ($broker_info['asnum'] < $broker_info['maxas'])
                    echo "\t<li><a href=\"broker.php?action=addap&amp;{$misc->href}$broker_href", 
                        "\">".$lang['strapplserver']." ".$lang['stradd']."</a></li>\n";
                if ($broker_info['asnum'] > $broker_info['minas'])
                    echo "\t<li><a href=\"broker.php?action=delap&amp;{$misc->href}$broker_href", 
                        "\">".$lang['strapplserver']." ".$lang['strdelete']."</a></li>\n";
            }
            echo "\t<li><a href=\"broker.php?action=setpara&amp;{$misc->href}$broker_href", 
                "\">".$lang['strparadb']."</a></li>\n";
            if ($broker_info['source_env'] != '0') 
                echo "\t<li><a href=\"broker.php?action=setenv&amp;{$misc->href}$broker_href", 
                    "\">SOURCE_ENV ".$lang['strparadb']."</a></li>\n";
            echo "\t<li><a href=\"broker.php?action=refresh&amp;{$misc->href}$broker_href", 
                "\">{$lang['strrefresh']}</a></li>\n";
            echo "</ul>\n";
        }

        $tk = $misc->ManagerCommand($_server_info['id'], "getlogfileinfo" , "broker:{$_REQUEST['broker']}\n");
        if ($tk['status']!="success") {
            echo $lang['logreadfail']." ".$tk['note'];
        }
        else if (isset($tk['logfileinfo'][0]['logfile'])) {
            $cnt = count($tk['logfileinfo'][0]['logfile']);
            $loginfo = $tk['logfileinfo'][0]['logfile'];
            if ($cnt > 0) {
                echo "<br>[Broker logs]<ul>\n";
                if (get_magic_quotes_gpc())
                    $viewlog = stripslashes($viewlog);
                for ($i=0; $i < $cnt; $i++) {
                    echo "\t<li>";
                    $urllogpath = urlencode($loginfo[$i]['path']);
                    if ($loginfo[$i]['size']>0)
                        echo "<a href=\"broker.php?action=viewlog&amp;viewlog=$urllogpath&amp;log_start_line=0".
                            "&amp;subject=broker&amp;{$misc->href}$broker_href&amp;\" onclick=\"show_waiting();\">";
                    echo $loginfo[$i]['path']."(";
                    echo $loginfo[$i]['type']." log/";
                    echo $loginfo[$i]['size']." byte(s)/";
                    echo $loginfo[$i]['lastupdate'].") ";
                    if ($loginfo[$i]['size']>0) echo "</a>";
                    if ($_server_info['cassuper'] == "admin") {
                        echo "<input type='button' value='".$lang['strdeletelog']."' onclick='confirm_url(\"".
                            $lang['strconfdeletelog']."\", \"broker.php?".
                            "action=resetlog&amp;logpath=$urllogpath&amp;subject=broker&amp;{$misc->href}$broker_href&amp;\")'>";
                    }
                    echo "</li>\n";
                    if (isset($action) && $action == "viewlog" && $viewlog == $loginfo[$i]['path']) {
                        include_once('./libraries/viewlog.inc.php');
                        manager_viewlog($loginfo[$i]['path'],
                            "broker.php?action=viewlog&amp;viewlog=$urllogpath&amp;subject=broker&amp;{$misc->href}$broker_href&amp;",
                            $log_start_line);
                    }
                }
                echo "</ul>\n";
            }
        }
    }

    $misc->printHeader($lang['strbroker'] . ' - ' . $_REQUEST['broker'],
                        "<script type=\"text/javascript\" src=\"tools.js\"></script>");
	$misc->printBody();

    switch ($action) {
    case 'resetlog':
        if ($_server_info['cassuper'] == "admin") {
            $logpath = urldecode($logpath);
            if (get_magic_quotes_gpc())
                $logpath = stripslashes($logpath);
            $tk = $misc->ManagerCommand($_server_info['id'], "removelog" , 
                "open:files\npath:$logpath\nclose:files\n");
            if ($tk['status']!="success") {
                doDefault($tk['note']);
                break;
            }
        }
        break;
    default:
        doDefault();
        break;
    case 'aprestart':
        $msg = "bname:$broker\nasnum:".$as_id;
        $tk = $misc->ManagerCommand($_server_info['id'], "broker_restart", $msg);
        if ($tk['status']!="success") 
            doDefault($lang['strbrokeropfailed']."\n".$tk['note'], TRUE);
        else {
            sleep(1);
            doDefault($lang['strbrokeropsuccess'], TRUE);
        }
        break;
    case 'addap':
        $msg = "bname:$broker";
        $tk = $misc->ManagerCommand($_server_info['id'], "broker_add", $msg);
        if ($tk['status']!="success") 
            doDefault($lang['strbrokeropfailed']."\n".$tk['note'], TRUE);
        else {
            sleep(1);
            doDefault($lang['strbrokeropsuccess'], TRUE);
        }
        break;
    case 'delap':
        $msg = "bname:$broker";
        $tk = $misc->ManagerCommand($_server_info['id'], "broker_drop", $msg);
        if ($tk['status']!="success") 
            doDefault($lang['strbrokeropfailed']."\n".$tk['note'], TRUE);
        else {
            sleep(1);
            doDefault($lang['strbrokeropsuccess'], TRUE);
        }
        break;
    case 'setpara':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        else if (isset($_POST['setpara'])) {
            $msg = "bname:$broker\nopen:param\n";
            foreach ($_POST as $bkey=>$bval) {
                if (substr($bkey,0,5) != 'PARA_') continue;
                $bkey = substr($bkey,5);
                $bval = trim($bval);
                $msg .= "$bkey:$bval\n";
            }
            $msg .= "close:param\n";

            $tk = $misc->ManagerCommand($_server_info['id'], "broker_setparam", $msg);
            if ($tk['status']!="success") 
                doDefault($lang['strbrokeropfailed']."\n".$tk['note']);
            else if (isset($tk['need_restart']) && $tk['need_restart'] == 'y')
                doDefault($lang['strbrokeropsuccess']."\n".$lang['strneedrestartcas'], TRUE);
            else 
                doDefault($lang['strbrokeropsuccess'], TRUE);
            break;
        }
        setPara();
        break;
    case 'setenv':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        else if (isset($_POST['setenv'])) {
            $msg = "bname:$broker\nopen:param\n";
            $in_var = preg_replace("(\r\n|\n|\r)", "<>", $in_var);
            $in_line = strtok($in_var, "<>");
            while ($in_line) {
                $in_line = trim($in_line);
                $pos = strpos($in_line, "=");
                if ($pos !== false && $pos > 0) {
                    $vkey = trim(substr($in_line, 0, $pos));
                    $vval = trim(substr($in_line, $pos+1));
                    $msg .= "$vkey:$vval\n";
                }
                $in_line = strtok("<>");
            }
            $msg .= "close:param\n";

            $tk = $misc->ManagerCommand($_server_info['id'], "setbrokerenvinfo", $msg);
            if ($tk['status']!="success") 
                doDefault($lang['strbrokeropfailed']."\n".$tk['note']);
            else 
                doDefault($lang['strbrokeropsuccess'], TRUE);
            break;
        }
        setEnv();
        break;
    case 'refresh':
        doDefault('', TRUE);
        break;
    }
	
	$misc->printFooter();

?>
