<?php
    include_once('./classes/ArrayRecordSet.php');

	/**
	 * Manage databases within a server
	 *
	 * $Id: all_broker.php,v 1.45.2.2 2007/07/09 14:55:21 xzilla Exp $
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');
	
	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
	if (!isset($msg)) $msg = '';

    function startbroker() {
        global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;

        $tk = $misc->ManagerCommand($_server_info['id'], "startunicas" , "");
        if ($tk['status']!="success") {
            doDefault($tk['note']);
        }
        else {
            $_reload_browser = true;
            sleep(1);
            doDefault('', TRUE);
        }
    }

    function stopbroker() {
        global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;

        $tk = $misc->ManagerCommand($_server_info['id'], "stopunicas" , "");
        if ($tk['status']!="success") {
            doDefault($tk['note']);
        }
        else {
            $_reload_browser = true;
            sleep(1);
            doDefault('', TRUE);
        }
    }

    function restartbroker() {
        global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;

        $tk = $misc->ManagerCommand($_server_info['id'], "stopunicas" , "");
        if ($tk['status']!="success") {
            doDefault($tk['note']);
        }
        else {
            sleep(2);
            $tk = $misc->ManagerCommand($_server_info['id'], "startunicas" , "");
            if ($tk['status']!="success") {
                doDefault($tk['note']);
            }
            else {
                $_reload_browser = true;
                sleep(1);
                doDefault('', TRUE);
            }
        }
    }


    function brokerstart() {
        global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;

        $tk = $misc->ManagerCommand($_server_info['id'], "broker_start" , "bname:".$_REQUEST['broker']);
        if ($tk['status']!="success") {
            doDefault($tk['note']);
        }
        else {
            $_reload_browser = true;
            sleep(1);
            $misc->getBroker($_REQUEST['broker'], TRUE);
            doDefault('', TRUE);
        }
    }

    function brokerstop() {
        global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;

        $tk = $misc->ManagerCommand($_server_info['id'], "broker_stop" , "bname:".$_REQUEST['broker']);
        if ($tk['status']!="success") {
            doDefault($tk['note']);
        }
        else {
            $_reload_browser = true;
            sleep(1);
            doDefault('', TRUE);
        }
    }

    function delBroker() {
        global $data, $misc, $db;
        global $lang, $broker;

        $misc->printTrail('broker');
        $misc->printTitle($lang['strdelbroker']);

        include_once "waiting.php";

        echo "<p>", sprintf($lang['strconfdropbroker'], $misc->printVal($broker)), "</p>\n";	
        echo "<form action=\"all_broker.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"delbroker\" />\n";
        echo $misc->form;
        echo "<input type=\"hidden\" name=\"in_brokername\" value=\"", htmlspecialchars($broker), "\" />\n";
        echo "<input type=\"submit\" name=\"delbroker\" value=\"{$lang['strdelbroker']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }

    function brokerrestart() {
        global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;

        $tk = $misc->ManagerCommand($_server_info['id'], "broker_stop" , "bname:".$_REQUEST['broker']);
        if ($tk['status']!="success") {
            doDefault($tk['note']);
        }
        else {
            sleep(2);
            $tk = $misc->ManagerCommand($_server_info['id'], "broker_start" , "bname:".$_REQUEST['broker']);
            if ($tk['status']!="success") {
                doDefault($tk['note']);
            }
            else {
                $_reload_browser = true;
                sleep(1);
                $misc->getBroker($_REQUEST['broker'], TRUE);
                doDefault('', TRUE);
            }
        }
    }

    function addBroker() {
        global $data, $misc, $db, $_server_info;
        global $lang;

        $misc->printTrail('broker');
        $misc->printTitle($lang['straddbroker']);

        include_once "waiting.php";

        $tk = $misc->ManagerCommand($_server_info['id'], "getaddbrokerinfo" , "");
        if ($tk['status'] != "success") {
            echo "<br>".$tk['note']."<br>";
            return;
        }
        if (!isset($tk['info']))
            $cnt = 0;
        else
            $cnt = count($tk['info']);
        $inuse_ports = "";
        $comm_port = 30000;
        for ($i = 0; $i < $cnt; $i ++) {
            $inuse_ports .= $tk['info'][$i]['bname']."(".$tk['info'][$i]['port'].") ";
            if ($tk['info'][$i]['port'] > $comm_port) 
                $comm_port = $tk['info'][$i]['port'];
        }
        $comm_port += 1000;
        echo "<form action=\"all_broker.php\" method=\"post\">\n";
        echo "<input type=\"hidden\" name=\"action\" value=\"addbroker\" />\n";
        echo $misc->form;
        echo "1. ".$lang['strbroker']." ".$lang['strname']." ".
            " <input type='text' name='in_brokername' size=16><br>\n";
        echo "2. ".$lang['strbroker']." ".$lang['strport']." ".
            " <input type='text' name='in_brokerport' size=6 value='$comm_port'><br>\n";
        echo "&nbsp;&nbsp;&nbsp;&nbsp;".$lang['strinuseport']." : $inuse_ports<br>\n";
        echo "3. ".$lang['strapplserver']." ".$lang['strtype']." ".
            " <input type='text' name='in_brokertype' size=6 value='CAS'> (CAS, VAS, WAS, ULS, AMS)<br>\n";
        echo "4. ".$lang['strapplserver']." MIN ".
            " <input type='text' name='in_brokermin' size=4 value='5'><br>\n";
        echo "5. ".$lang['strapplserver']." MAX ".
            " <input type='text' name='in_brokermax' size=4 value='20'><br>\n";
        echo "6. APPL ROOT <input type='text' name='in_applroot' size=48>(for VAS, WAS, ULS,AMS)<br>\n";
        echo "<input type=\"submit\" name=\"addbroker\" value=\"{$lang['straddbroker']}\"  onclick=\"show_waiting();\"/>\n";
        echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
        echo "</form>\n";
    }

	/**
	 * Show default list of databases in the server
	 */
    function doDefault($msg = '', $refresh = false) {
        global $data, $conf, $misc, $_server_info;
        global $lang, $mgrmsg, $action, $log_start_line, $viewlog;

        function svPre(&$rowdata, $actions) {
            global $_server_info;
            if ($_server_info['cassuper'] != "admin") {
                $actions['brokerstart']['disable'] = true;
                $actions['brokerstop']['disable'] = true;
                $actions['brokerrestart']['disable'] = true;
                $actions['delbroker']['disable'] = true;
            }
            else {
                if (isset($rowdata->f['state']) && $rowdata->f['state'] == "ON") {
                    $actions['brokerstart']['disable'] = true;
                    $actions['delbroker']['disable'] = true;
                }
                else {
                    $actions['brokerstop']['disable'] = true;
                    $actions['brokerrestart']['disable'] = true;
                }
            }
            return $actions;
        }

        if ($refresh === true) {
            if ($misc->ManagerRefresh($_server_info['id'], "unicasinfo") === false)
                $msg .= $mgrmsg;
            $_server_info = $misc->getServerInfo();
        }
        $misc->printTrail('server');
        $misc->printTabs('server','broker');
        $misc->printTitle($_server_info['UNICASVER'],'');
        $misc->printMsg($msg);


        $columns = array(
            'broker' => array(
                'title' => $lang['strname'],
                'field' => 'name',
            ),
            'status' => array(
                'title' => $lang['strstatus'],
                'field' => 'state',
            ),
            'process' => array(
                'title' => $lang['strprocess'],
                'field' => 'pid',
            ),
            'port' => array(
                'title' => $lang['strport'],
                'field' => 'port',
            ),
            'appserver' => array(
                'title' => $lang['strappserver'],
                'field' => 'as',
            ),
            'queue' => array(
                'title' => $lang['strqueue'],
                'field' => 'jq',
            ),
            'thread' => array(
                'title' => $lang['strthread'],
                'field' => 'thr',
            ),
            'request' => array(
                'title' => $lang['strrequest'],
                'field' => 'req',
            ),
            'autoadd' => array(
                'title' => $lang['strautoadd'],
                'field' => 'auto',
            ),
            'sqllog' => array(
                'title' => $lang['strsqllog'],
                'field' => 'sqll',
            ),
            'actions' => array(
                'title' => $lang['stractions'],
            )
        );

        $actions = array(
            'properties' => array(
                'title' => $lang['strproperties'],
                'url'   => "redirect.php?subject=broker&amp;{$misc->href}&amp;",
                'vars'  => array('broker' => 'name'),
            ),
            'brokerstart' => array(
                'title' => $lang['strstartdb'],
                'url'   => "all_broker.php?subject=server&amp;action=brokerstart&amp;{$misc->href}&amp;",
                'vars'  => array('broker' => 'name'),
            ),
            'brokerrestart' => array(
                'title' => $lang['strrestartdb'],
                'url'   => "all_broker.php?subject=server&amp;action=brokerrestart&amp;{$misc->href}&amp;",
                'vars'  => array('broker' => 'name'),
            ),
            'brokerstop' => array(
                'title' => $lang['strstopdb'],
                'url'   => "all_broker.php?subject=server&amp;action=brokerstop&amp;{$misc->href}&amp;",
                'vars'  => array('broker' => 'name'),
            ),
            'delbroker' => array(
                'title' => $lang['strdelbroker'],
                'url'   => "all_broker.php?subject=server&amp;action=delbroker&amp;{$misc->href}&amp;",
                'vars'  => array('broker' => 'name'),
            ),
        );

        $datrows = new ArrayRecordSet($_server_info['brokers']);

        $misc->printTable($datrows, $columns, $actions, $lang['strnodatabases'], 'svPre');

        include_once "waiting.php";

        echo "<br><ul>\n";

        if ($_server_info['cassuper'] == 'admin') {
            if ($_server_info['broker'] == 'ON') {
                echo "\t<li><a href=\"all_broker.php?action=stopbroker&amp;subject=server&amp;{$misc->href}&amp;\"".
                    " onclick=\"show_waiting();\">{$lang['strstopbrokerenv']}</a></li>\n";
                echo "\t<li><a href=\"all_broker.php?action=restartbroker&amp;subject=server&amp;{$misc->href}&amp;\"".
                    " onclick=\"show_waiting();\">{$lang['strrestartbrokerenv']}</a></li>\n";
            }
            else {
                echo "\t<li><a href=\"all_broker.php?action=startbroker&amp;subject=server&amp;{$misc->href}&amp;\"".
                    " onclick=\"show_waiting();\">{$lang['strstartbrokerenv']}</a></li>\n";
            }

            echo "\t<li><a href=\"all_broker.php?action=addbroker&amp;subject=server&amp;{$misc->href}&amp;\"".
                " onclick=\"show_waiting();\">{$lang['straddbroker']}</a></li>\n";
        }
        echo "\t<li><a href=\"all_broker.php?action=refresh&amp;subject=server&amp;{$misc->href}&amp;\"".
            " onclick=\"show_waiting();\">{$lang['strrefresh']}</a></li>\n";
        echo "</ul>\n";

        if ($_server_info['cassuper'] == 'admin') {
            if (isset($_server_info['brokeradminlog'])  && count($_server_info['brokeradminlog']) > 0) {
                echo "<br>[Broker admin logs]<ul>\n";
                for ($i=0; $i < count($_server_info['brokeradminlog']); $i++) {
                    if (isset($_server_info['brokeradminlog'][$i])) {
                        echo "\t<li>";
                        if ($_server_info['brokeradminlog'][$i]['size']>0)
                            echo "<a href=\"all_broker.php?action=viewlog&amp;viewlog={$i}&amp;log_start_line=0".
                                "&amp;subject=server&amp;{$misc->href}&amp;\" onclick=\"show_waiting();\">";
                        echo $_server_info['brokeradminlog'][$i]['path']."(";
                        echo $_server_info['brokeradminlog'][$i]['size']." byte(s)/";
                        echo $_server_info['brokeradminlog'][$i]['lastupdate'].") ";
                        $urllogpath = urlencode($_server_info['brokeradminlog'][$i]['path']);
                        if ($_server_info['brokeradminlog'][$i]['size']>0) echo "</a>";
                        echo "<input type='button' value='".$lang['strdeletelog']."' onclick='confirm_url(\"".
                            $lang['strconfdeletelog']."\", \"all_broker.php?".
                            "action=resetlog&amp;logpath=$urllogpath&amp;subject=server&amp;{$misc->href}&amp;\")'>";
                        echo "</li>\n";
                        if (isset($action) && $action == "viewlog" && $viewlog == $i) {
                            include_once('./libraries/viewlog.inc.php');
                            manager_viewlog($_server_info['brokeradminlog'][$i]['path'],
                                "all_broker.php?action=viewlog&amp;viewlog={$i}&amp;subject=server&amp;{$misc->href}&amp;",
                                $log_start_line);
                        }
                    }
                }
                echo "</ul>\n";
            }
        }
    }
	
	$misc->printHeader($lang['strbroker'], "<script type=\"text/javascript\" src=\"tools.js\"></script>");
	$misc->printBody();

    switch ($action) {
    case 'startbroker':
        startbroker();
        break;
    case 'stopbroker':
        stopbroker();
        break;
    case 'restartbroker':
        restartbroker();
        break;
    case 'brokerstart':
        brokerstart();
        break;
    case 'brokerstop':
        brokerstop();
        break;
    case 'delbroker':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        else if (isset($_POST['delbroker'])) {
            $msg = "bname:$in_brokername\n";
            $tk = $misc->ManagerCommand($_server_info['id'], "deletebroker", $msg);
            if ($tk['status']!="success") 
                doDefault($lang['strbrokeropfailed']."\n".$tk['note']);
            else  {
                $_reload_browser = true;
                sleep(1);
                doDefault($lang['strbrokeropsuccess']."\n".$lang['strneedrestartcas'], TRUE);
            }
            break;
        }
        delBroker();
        break;
    case 'addbroker':
        if (isset($_POST['cancel'])) {
            doDefault();
            break;
        }
        else if (isset($_POST['addbroker'])) {
            $msg = "bname:$in_brokername\n";
            $tk = $misc->ManagerCommand($_server_info['id'], "addbroker", $msg);
            if ($tk['status']!="success") 
                doDefault($lang['strbrokeropfailed']."\n".$tk['note']);
            else {
                $msg .= "open:params\nBROKER_PORT:$in_brokerport\nAPPL_SERVER:$in_brokertype\n";
                if ($in_brokertype != "CAS") 
                    $msg .= "APPL_ROOT:$in_applroot\n";
                $msg .= "MIN_NUM_APPL_SERVER:$in_brokermin\nMAX_NUM_APPL_SERVER:$in_brokermax\n";
                $msg .= "AUTO_ADD_APPL_SERVER:ON\nAPPL_SERVER_SHM_ID:$in_brokerport\nAPPL_SERVER_MAX_SIZE:10\nLOG_DIR:log\n";
                $msg .= "LOG_BACKUP:OFF\nSOURCE_ENV: \nACCESS_LOG:ON\nSQL_LOG:OFF\nSQL_LOG_TIME:1000000\nSQL_LOG_MAX_SIZE:2000000\n";
                $msg .= "KEEP_CONNECTION:AUTO\nTIME_TO_KILL:60\nSESSION_TIMEOUT:300\nJOB_QUEUE_SIZE:100\nMAX_STRING_LENGTH:-1\n";
                $msg .= "STRIPPED_COLUMN_NAME:ON\nACCESS_LIST: \nclose:params\n";
                $tk = $misc->ManagerCommand($_server_info['id'], "broker_setparam", $msg);
                if ($tk['status']!="success") 
                    doDefault($lang['strbrokeropfailed']."\n".$tk['note']);
                else if (isset($tk['need_restart']) && $tk['need_restart'] == 'y')
                    doDefault($lang['strbrokeropsuccess']."\n".$lang['strneedrestartcas'], TRUE);
                else
                    doDefault($lang['strbrokeropsuccess'], TRUE);
            }
            break;
        }
        addBroker();
        break;
    case 'brokerrestart':
        brokerrestart();
        break;
    case 'resetlog':
        $logpath = urldecode($logpath);
        if (get_magic_quotes_gpc())
            $logpath = stripslashes($logpath);
        $tk = $misc->ManagerCommand($_server_info['id'], "removelog" , 
            "open:files\npath:$logpath\nclose:files\n");
        if ($tk['status']!="success") {
            doDefault($tk['note']);
            break;
        }
        doDefault('', TRUE);
        break;
    default:
        doDefault();
        break;
    case 'refresh':
        doDefault('', TRUE);
        break;
    }	

	$misc->printFooter();
?>
