# Copyright 1999-2008 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header$

inherit eutils

DESCRIPTION="mzproxy daemon (PROXY/TELNETD/TCPFORWARD)"
HOMEPAGE="http://kldp.net/projects/mzproxy/"
SRC_URI="http://kldp.net/frs/download.php/4724/${PN}-v${PV}-${PR}.tar.bz2"

LICENSE="GPL-2"
KEYWORDS="arm amd64 ia64 mips mipsel ppc ppc64 sparc x86"
SLOT="0"
IUSE="xinetd"

DEPEND="xinetd? ( sys-apps/xinetd )"

S="${WORKDIR}/${PN}-v${PV}-${PR}"

src_unpack() {
	unpack ${PN}-v${PV}-${PR}.tar.bz2
}

src_compile() {
	econf || die "econf failed"
	emake CFLAGS="${CFLAGS}" || die "emake failed"
}

src_install() {
	dobin mzproxy || die "dobin failed"
	dodoc LICENSES README
	
	if use xinetd ; then
		insinto /etc/xinetd.d
		newins "${S}/mzproxy.xinetd.example" mzproxy.example
	fi
}
