/*
 * Decompiled with CFR 0.152.
 */
package JPICSDK;

import JPICSDK.JpicDriverInterface;
import JPICSDK.JpicDriverOwnerInterface;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JpicDriverManager {
    private Map<String, JpicDriverInterface> driverMap_;
    private Map<String, String> driverNameMap_;
    private JpicDriverOwnerInterface owner_;
    private Map<String, String> domainList_;

    public JpicDriverManager(JpicDriverOwnerInterface owner) {
        this.setOwner(owner);
        this.driverMap_ = new HashMap();
        this.driverNameMap_ = new HashMap();
        this.domainList_ = new HashMap();
        this.refreshDriverList();
    }

    public boolean request(String uri) {
        String domain = uri.split("/")[0];
        if (!this.driverMap_.keySet().contains(domain)) {
            return false;
        }
        JpicDriverInterface driver = (JpicDriverInterface)this.driverMap_.get(domain);
        if (driver == null) {
            if (!this.loadDriver(domain)) {
                System.out.println("loadDriver \uc2e4\ud328");
            } else {
                driver = (JpicDriverInterface)this.driverMap_.get(domain);
            }
            this.driverMap_.put(domain, driver);
        }
        return driver.request(uri);
    }

    public boolean loadDriver(String domain) {
        String currentPath;
        if (!this.driverMap_.keySet().contains(domain)) {
            return false;
        }
        if (this.driverMap_.get(domain) != null) {
            return true;
        }
        try {
            currentPath = new File("").getCanonicalPath();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        String jpicDriverPath = String.valueOf(currentPath) + "\\bin\\JpicDriver\\";
        try {
            File jpicDriverFile = new File(String.valueOf(jpicDriverPath) + (String)this.driverNameMap_.get(domain) + ".jar");
            URL classURL = new URL("jar:" + jpicDriverFile.toURI().toURL() + "!/");
            URLClassLoader classLoader = new URLClassLoader(new URL[]{classURL});
            Class<?> driverClass = classLoader.loadClass("JpicDriver." + (String)this.driverNameMap_.get(domain));
            Object object = driverClass.newInstance();
            if (object instanceof JpicDriverInterface) {
                JpicDriverInterface driver = (JpicDriverInterface)object;
                driver.setOwner(this.owner_);
                this.driverMap_.put(domain, driver);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            System.out.println("loadDriver() Exception");
            return false;
        }
    }

    public boolean unloadDriver(String domain) {
        if (!this.driverMap_.keySet().contains(domain)) {
            return false;
        }
        if (this.driverMap_.get(domain) == null) {
            return true;
        }
        this.driverMap_.remove(domain);
        System.gc();
        return true;
    }

    public boolean unloadAllDriver() {
        this.driverMap_.clear();
        System.gc();
        return true;
    }

    public void setOwner(JpicDriverOwnerInterface owner) {
        this.owner_ = owner;
    }

    public JpicDriverOwnerInterface getOwner() {
        return this.owner_;
    }

    public Set<String> getLoadedDriverList() {
        return this.driverMap_.keySet();
    }

    public void refreshDriverList() {
        File[] drivers;
        String currentPath;
        int cnt = 0;
        try {
            currentPath = new File("").getCanonicalPath();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return;
        }
        String jpicDriverPath = String.valueOf(currentPath) + "\\bin\\JpicDriver";
        File jpicDriverFolder = new File(jpicDriverPath);
        if (!jpicDriverFolder.isDirectory()) {
            System.out.println("JpicDriver \ud3f4\ub354\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            System.exit(1);
        }
        File[] fileArray = drivers = jpicDriverFolder.listFiles();
        int n = drivers.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String[] fileName = file.getName().split("\\.");
            System.out.println(String.valueOf(file.getName()) + " size: " + fileName.length);
            if (file.isFile() && fileName.length >= 2 && fileName[1].compareTo("jar") == 0) {
                String driverName = fileName[0];
                try {
                    URL classURL = new URL("jar:" + file.toURI().toURL() + "!/");
                    URLClassLoader classLoader = new URLClassLoader(new URL[]{classURL});
                    Class<?> driverInfoClass = classLoader.loadClass("JpicDriver." + driverName + "Info");
                    Object object = driverInfoClass.newInstance();
                    this.domainList_.put("" + cnt++, object.toString());
                    this.driverMap_.put(object.toString(), null);
                    this.driverNameMap_.put(object.toString(), driverName);
                }
                catch (Exception ex) {
                    System.out.println("refreshDriverList() Exception");
                }
            }
            ++n2;
        }
    }

    public void setCaching(boolean isCachingOn, String domain) {
        if (domain.compareTo("all") == 0) {
            int i = 0;
            while (i < this.domainList_.size()) {
                String driverName = (String)this.domainList_.get("" + i);
                JpicDriverInterface driver = (JpicDriverInterface)this.driverMap_.get(driverName);
                if (driver != null) {
                    driver.setCaching(isCachingOn);
                }
                ++i;
            }
        } else {
            JpicDriverInterface driver = (JpicDriverInterface)this.driverMap_.get(domain);
            if (driver == null) {
                if (!this.loadDriver(domain)) {
                    System.out.println("loadDriver \uc2e4\ud328");
                    return;
                }
                driver = (JpicDriverInterface)this.driverMap_.get(domain);
                this.driverMap_.put(domain, driver);
                driver.setCaching(isCachingOn);
            }
        }
    }

    public boolean isCachingOn(String domain) {
        JpicDriverInterface driver = (JpicDriverInterface)this.driverMap_.get(domain);
        if (driver == null) {
            if (!this.loadDriver(domain)) {
                System.out.println("loadDriver \uc2e4\ud328");
                return false;
            }
            driver = (JpicDriverInterface)this.driverMap_.get(domain);
            this.driverMap_.put(domain, driver);
        }
        return driver.isCachingOn();
    }

    public void setCachSize(int size, String domain) {
        JpicDriverInterface driver = (JpicDriverInterface)this.driverMap_.get(domain);
        if (driver == null) {
            if (!this.loadDriver(domain)) {
                System.out.println("loadDriver \uc2e4\ud328");
                return;
            }
            driver = (JpicDriverInterface)this.driverMap_.get(domain);
            this.driverMap_.put(domain, driver);
            driver.setCachSize(size);
        }
    }

    public int getCachSize(String domain) {
        JpicDriverInterface driver = (JpicDriverInterface)this.driverMap_.get(domain);
        if (driver == null) {
            if (!this.loadDriver(domain)) {
                System.out.println("loadDriver \uc2e4\ud328");
                return -1;
            }
            driver = (JpicDriverInterface)this.driverMap_.get(domain);
            this.driverMap_.put(domain, driver);
        }
        return driver.getCachSize();
    }
}

