// MyCalibrate.h: interface for the CMyCalibrate class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MYCALIBRATE_H__3E350CD6_5D95_44E5_BEB2_334010110151__INCLUDED_)
#define AFX_MYCALIBRATE_H__3E350CD6_5D95_44E5_BEB2_334010110151__INCLUDED_

#include <cv.h>
#include <highgui.h>

#include <vector>
using namespace std;

#include "MyStaticView.h"


typedef struct MYCHECKLINE
{
	double d;
	BOOL p_m;
	BOOL x_eq;

	CvPoint line1,line2;

}MyCheckLine;

typedef struct PADPOINT
{
	CvPoint UpLeftPoint;
	CvPoint UpRightPoint;
	CvPoint DownLeftPoint;
	CvPoint DownRightPoint;
}PadPoint;


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMyCalibrate  
{
public:
	void Reset();
	BOOL GetbFind4Point();

	CMyStaticView *m_Screen_Line;
	CMyStaticView *m_Screen_Result;
	//////////////////////////////////////////////////////////////////////////
	void Calibration();
	void Save_MousePad_OutArea2();
	CvPoint GetPoint_2Point(CPoint p1, CPoint p2, int num);
	CvPoint GetPadPixPoint(CvPoint po_1,CvPoint po_2,CvPoint po_3,CvPoint po_4);
	void DrawMousePad(IplImage *image);
	void GetPoint_Pad_Rect();
	PadPoint m_PadPoint;
	vector<CPoint> m_Result_Point;
	void DrawCornerPoint(IplImage *image,MyCheckLine *Check_Line,int count);
	void Find_CornerPoint(IplImage *pGrayImage);
	void FindHand();
	void Get_MousePad_Area_Contour(IplImage *pGrayImage);
	void Save_MousePad_OutArea();
	IplImage *m_pMainImage;
	IplImage *m_pDeleteAreaImage;
	IplImage *m_pMousePadImage;
	IplImage *m_pResultImage;		// Result Image
	IplImage *m_pRectangleLineImage;
	int	CENTER_POINT_LIGHT;		//    
	//////////////////////////////////////////////////////////////////////////

	CMyCalibrate();
	virtual ~CMyCalibrate();

};

#endif // !defined(AFX_MYCALIBRATE_H__3E350CD6_5D95_44E5_BEB2_334010110151__INCLUDED_)
