// CamPlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CamPlayer.h"
#include "CamPlayerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCamPlayerDlg dialog

CCamPlayerDlg::CCamPlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCamPlayerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCamPlayerDlg)
	m_Edit_Board_Limit = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCamPlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCamPlayerDlg)
	DDX_Control(pDX, IDC_LIST_INFOMATION, m_List_Infomation);
	DDX_Text(pDX, IDC_EDIT_BOARD_COLOR_LIMIT, m_Edit_Board_Limit);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCamPlayerDlg, CDialog)
	//{{AFX_MSG_MAP(CCamPlayerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_CAMPLAY, OnBtnCamplay)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_STOP, OnBtnStop)
	ON_BN_CLICKED(IDC_BTN_REFRESH, OnBtnRefresh)
	ON_BN_CLICKED(IDC_BTN_REFRESH_HELP, OnBtnRefreshHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCamPlayerDlg message handlers

BOOL CCamPlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	//////////////////////////////////////////////////////////////////////////
	//
	Initialize();
	//
	//////////////////////////////////////////////////////////////////////////


	//////////////////////////////////////////////////////////////////////////
	//
	m_Static_Screen_Main.SubclassDlgItem(IDC_STATIC_SCREEN_MAIN,this);
	m_Static_Screen_Result.SubclassDlgItem(IDC_STATIC_SCREEN_RESULT,this);

	m_Static_Screen_Main.MoveWindow(20,200,320,240,TRUE);
	m_Static_Screen_Result.MoveWindow(350,200,320,240,TRUE);

	m_Calibration.m_Screen_Result = &m_Static_Screen_Result;
	//
	//////////////////////////////////////////////////////////////////////////

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCamPlayerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCamPlayerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCamPlayerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCamPlayerDlg::OnBtnCamplay() 
{
	OnBtnStop();
	KillTimer(4);

	if(m_pCapture != NULL)
	{
		return;
	}
	//  ī޶ 
	
	m_pCapture = cvCaptureFromCAM(0);	

	cvGrabFrame( m_pCapture );
	m_pMainImage = cvRetrieveFrame( m_pCapture );
	
	
	SetTimer(1,0,NULL);
	
	m_Findtime = GetCurrentTime();
	SetTimer(3,0,NULL);

	m_Static_Screen_Main.m_bStart = FALSE;
	m_Static_Screen_Result.m_bStart = FALSE;

	m_Dlg_Show = FALSE;
	//
	//////////////////////////////////////////////////////////////////////////

	SetListBox_Infomation("===========================================");
	SetListBox_Infomation("CAM Start~!");
	SetListBox_Infomation("===========================================");
}

void CCamPlayerDlg::OnTimer(UINT nIDEvent) 
{
	if(nIDEvent == 1)		// ȭ é
	{
		// ķ ޾ƿ ̹ .
		cvGrabFrame( m_pCapture );
        m_pMainImage = cvRetrieveFrame( m_pCapture );
/*
		cvNamedWindow("Main");
		cvShowImage("Main",m_pMainImage);
*/
		// 簢   Ʈ  簢  ׸.
		if(m_Calibration.m_pRectangleLineImage != NULL)
		{
			IplImage *pTempImage = (IplImage *)cvClone(m_pMainImage);
			
			for(int i = 0;i<m_pMainImage->height;i++)
			{
				for(int j = 0;j<m_pMainImage->width;j++)
				{
					if(m_Calibration.m_pRectangleLineImage->imageData[i*m_pMainImage->width+j] != 0)
					{
						cvRectangle(pTempImage,cvPoint(j,i),cvPoint(j,i),CV_RGB(255,255,255),1);
					}
				}
			}

			// Static  ӹ޴ Ŭ ̹ Ѱ.
			m_Static_Screen_Main.MainImageCopy(pTempImage);
			m_Static_Screen_Main.Invalidate(TRUE);
		}
		else
		{
			m_Static_Screen_Main.MainImageCopy(m_pMainImage);
			m_Static_Screen_Main.Invalidate(TRUE);
		}

		m_bStart_View = TRUE;
	}
		if(nIDEvent == 2)		// Calibration ȭ ÷
	{
		m_Calibration.Calibration();
	}
	if(nIDEvent == 3)
	{
		if(m_bStart_View == TRUE)		// ī޶ ۵ Ǿ .
		{
			if( (GetCurrentTime() - m_Findtime ) > 3000)
			{
				SetListBox_Infomation("3 ");
				SetListBox_Infomation("ũ  ã Ͽϴ. ġ ʱȭ  ֽʽÿ.");
				KillTimer(3);
				AfxMessageBox("͸ ã Ͽϴ.");				
			}
			else
			{
				m_Calibration.m_pMainImage = m_pMainImage;
				
				if(m_bStart_Calibration == TRUE)
				{
					SetListBox_Infomation("ũ  ˻ Ϸ");
					m_Calibration.Save_MousePad_OutArea2();
				}
				else
				{
					m_bStart_Calibration = TRUE;
				}
				if(m_Calibration.GetbFind4Point() == TRUE)
				{
					KillTimer(3);
					SetTimer(2,0,NULL);
				}
			}			
		}
	}
	if(nIDEvent == 5)
	{
		cvGrabFrame( m_pCapture );
        m_pMainImage = cvRetrieveFrame( m_pCapture );
		m_Static_Screen_Main.m_bStart = FALSE;
		m_Static_Screen_Main.MainImageCopy(m_pMainImage);
		m_Static_Screen_Main.Invalidate(TRUE);
	}
	CDialog::OnTimer(nIDEvent);
}

void CCamPlayerDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	cvDestroyAllWindows();
}

void CCamPlayerDlg::OnBtnStop() 
{
	Reset();

	SetListBox_Infomation("===========================================");
	SetListBox_Infomation("CAM Stop~!");
	SetListBox_Infomation("===========================================");
}

void CCamPlayerDlg::Initialize()
{
	SetListBox_Infomation("ī޶, ̹ ʱȭ ");
	m_bStart_View = FALSE;
	m_pCapture = NULL;
	m_pMainImage = NULL;

	m_Edit_Board_Limit = 20;
	UpdateData(FALSE);
}

void CCamPlayerDlg::Reset()
{
	SetListBox_Infomation("ڷ ʱȭ");
	KillTimer(1);
	KillTimer(2);
	
	if(m_pCapture != NULL)
		cvReleaseCapture(&m_pCapture);

	cvDestroyAllWindows();	
}

void CCamPlayerDlg::SetListBox_Infomation(CString str)
{
	//////////////////////////////////////////////////////////////////////////
	// TEXT OUT
	m_List_Infomation.AddString(str);
	m_List_Infomation.SetTopIndex(m_List_Infomation.GetCount()-5);
	//
	//////////////////////////////////////////////////////////////////////////	
}

void CCamPlayerDlg::OnBtnRefresh() 
{
	SetListBox_Infomation("EditBox  ° ũ  ");


	m_Calibration.CENTER_POINT_LIGHT = m_Edit_Board_Limit;

	UpdateData(TRUE);

	m_Findtime = GetCurrentTime();
	m_bStart_Calibration = FALSE;
	m_Calibration.Reset();

	SetTimer(3,0,NULL);
}

void CCamPlayerDlg::OnBtnRefreshHelp() 
{
	Reset();
	CMy_Refresh_Help Refresh_Help;
	Refresh_Help.DoModal();
}
