-- lfs  ε. DLL ̸ ǥذ´ٸǷ
-- ε ۾ require()  ʰ
--  
if not package.loaded['lfs'] then
  assert(package.loadlib("lfs-5.1.dll", "luaopen_lfs"))()
  package.loaded['lfs'] = true
end
  
lfsx = {}
local function get_lua_pattern(pattern)
	local lua_pattern = string.lower(pattern)
	lua_pattern = string.gsub(pattern, "%.", "%%.")
	lua_pattern = string.gsub(lua_pattern, "%*", "(.*)")
	return '^' .. lua_pattern .. '$'
end

local function build_list(path, pattern, list, recursive)
	for file in lfs.dir(path) do
		if file ~= "." and file ~=".." then
			local f = path..'\\'..file
			local attr = lfs.attributes (f)
			if recursive and attr.mode == "directory" then
				build_list(f, pattern, list, recursive)
			else
				if(string.find(string.lower(file), pattern)) then
					table.insert(list, {path, file})
				end
			end
		end
	end
end

local function enum_files(list)
	for i, v in ipairs(list) do
		coroutine.yield(v[1], v[2])
	end
end

-- ־   ϴ ϵ ο ̸  ϴ ⸦ ȯ
-- for    .
-- : for path, file in lfsx.files("test", "*.xml") do
--	     print(path, file)
--     end
function lfsx.files(dir, file_pattern, recursive)
	if recursive == nil then recursive = true end
	local pattern = get_lua_pattern(file_pattern)
	local list = {}
	build_list(dir, pattern, list, recursive)
	return coroutine.wrap(function () enum_files(list) end)
end

-- ־ ΰ ͸̸ true, true ȯ
-- ͸ ƴϳ ־ ΰ ϸ nil, true ȯ
-- ƿ  ʴ ̸ nil, nil ȯ

function lfsx.is_dir(path)
	local fileattr = lfs.attributes(luascript_path) or {mode=nil}
	if fileattr.mode == 'directory' then return true, true end
	if mode ~= nil then return false, true end
end

-- ־ ΰ ̸ true ȯ
--  ƴϳ ־ ΰ ϸ false, true ȯ
-- ƿ  ʴ ̸ nil, nil ȯ
function lfsx.is_file(path)
	local fileattr = lfs.attributes(path) or {mode=nil}
	if fileattr.mode == 'file' then 
		return true, true 
	end
	if mode ~= nil then 
		return false, true 
	end
end
