﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:output method="xml" version="1.0" indent="yes"/>
	
	<xsl:template match="/">
		
		<xsl:variable name="docbook.dir">
			<xsl:value-of select="'file:///'"/>
			<xsl:value-of select=" translate($dir , '\' , '/')  "/>
		</xsl:variable>
		
		<xsl:comment xml:space="preserve"><![CDATA[
This is an example configuration file for FOP.
This file contains the same settings as the default values
and will have no effect if used unchanged.

Relative config url's will be resolved relative to
the location of this file.
]]></xsl:comment>
		
		<xsl:comment><![CDATA[ NOTE: This is the version of the configuration ]]></xsl:comment>
		<fop version="1.0">
			
			<xsl:comment><![CDATA[ Base URL for resolving relative URLs ]]></xsl:comment>
			<base><xsl:value-of select="$docbook.dir"/>			</base>
			
			<xsl:comment><![CDATA[ Source resolution in dpi (dots/pixels per inch) for determining
 the size of pixels in SVG and bitmap images, default: 72dpi ]]></xsl:comment>
			<source-resolution>72</source-resolution>
			<xsl:comment><![CDATA[ Target resolution in dpi (dots/pixels per inch) for specifying
 the target resolution for generated bitmaps, default: 72dpi ]]></xsl:comment>
			<target-resolution>72</target-resolution>
			
			<xsl:comment><![CDATA[ Default page-height and page-width, in case
 value is specified as auto ]]></xsl:comment>
			<default-page-settings height="11in" width="8.26in"/>
			
			<xsl:comment><![CDATA[ Information for specific renderers ]]></xsl:comment>
			<xsl:comment><![CDATA[ Uses renderer mime type for renderers ]]></xsl:comment>
			<renderers>
				<renderer mime="application/pdf">
					<filterList>
						<xsl:comment><![CDATA[ provides compression using zlib flate (default is on) ]]></xsl:comment>
						<value>flate</value>
						
						<xsl:comment><![CDATA[ encodes binary data into printable ascii characters (default off)
This provides about a 4:5 expansion of data size ]]></xsl:comment>
						<xsl:comment><![CDATA[ <value>ascii-85</value> ]]></xsl:comment>
						
						<xsl:comment><![CDATA[ encodes binary data with hex representation (default off)
This filter is not recommended as it doubles the data size ]]></xsl:comment>
						<xsl:comment><![CDATA[ <value>ascii-hex</value> ]]></xsl:comment>
					</filterList>
					
					<fonts>
						<xsl:comment><![CDATA[ embedded fonts ]]></xsl:comment>
						<xsl:comment><![CDATA[
        This information must exactly match the font specified
        in the fo file. Otherwise it will use a default font.

        For example,
        <fo:inline font-family="Arial" font-weight="bold" font-style="normal">
            Arial-normal-normal font
        </fo:inline>
        for the font triplet specified by:
        <font-triplet name="Arial" style="normal" weight="bold"/>

        If you do not want to embed the font in the pdf document
        then do not include the "embed-url" attribute.
        The font will be needed where the document is viewed
        for it to be displayed properly.

        possible styles: normal | italic | oblique | backslant
        possible weights: normal | bold | 100 | 200 | 300 | 400
                          | 500 | 600 | 700 | 800 | 900
        (normal = 400, bold = 700)
]]></xsl:comment>
						
						<xsl:comment><![CDATA[
        <font metrics-url="arial.xml" kerning="yes" embed-url="arial.ttf">
          <font-triplet name="Arial" style="normal" weight="normal"/>
          <font-triplet name="ArialMT" style="normal" weight="normal"/>
        </font>
        <font metrics-url="arialb.xml" kerning="yes" embed-url="arialb.ttf">
          <font-triplet name="Arial" style="normal" weight="bold"/>
          <font-triplet name="ArialMT" style="normal" weight="bold"/>
        </font>
]]></xsl:comment>
						
						<xsl:variable name="curr.font.dir">
							<xsl:value-of
								select="concat($docbook.dir , '/fonts/')"/>
						</xsl:variable>
						
						<!-- 폰트 설정 생성 -->
						<xsl:for-each select="/init/fontList/font">
							<xsl:sort select="@name" data-type="text"
								order="ascending" case-order="lower-first"/>
							
							<xsl:call-template name="create.font.metric">
								<xsl:with-param name="font.dir">
									<xsl:value-of select="$curr.font.dir"/>
								</xsl:with-param>
								<xsl:with-param name="node" select="."/>
							</xsl:call-template>
							
						</xsl:for-each>
						
					</fonts>
					
					<xsl:comment><![CDATA[ This option lets you specify additional options on an XML handler ]]></xsl:comment>
					<xsl:comment><![CDATA[
      <xml-handler namespace="http://www.w3.org/2000/svg">
        <stroke-text>false</stroke-text>
      </xml-handler>
]]></xsl:comment>
				</renderer>
				
				<renderer mime="application/postscript">
					<xsl:comment><![CDATA[ This option forces the PS renderer to rotate landscape pages ]]></xsl:comment>
					<xsl:comment><![CDATA[
      <auto-rotate-landscape>true</auto-rotate-landscape>]]></xsl:comment>
					<xsl:comment><![CDATA[ This option lets you specify additional options on an XML handler ]]></xsl:comment>
					<xsl:comment><![CDATA[
      <xml-handler namespace="http://www.w3.org/2000/svg">
        <stroke-text>false</stroke-text>
      </xml-handler>
      ]]></xsl:comment>
				</renderer>
				
				<renderer mime="application/vnd.hp-PCL">
				</renderer>
				
				<xsl:comment><![CDATA[ MIF does not have a renderer
    <renderer mime="application/vnd.mif">
    </renderer>
    ]]></xsl:comment>
				
				<renderer mime="image/svg+xml">
					<format type="paginated"/>
					<link value="true"/>
					<strokeText value="false"/>
				</renderer>
				
				<renderer mime="application/awt">
				</renderer>
				
				<renderer mime="text/xml">
				</renderer>
				
				<xsl:comment><![CDATA[ RTF does not have a renderer
    <renderer mime="text/rtf">
    </renderer>
    ]]></xsl:comment>
				
				<renderer mime="text/plain">
					<pageSize columns="80"/>
				</renderer>
				
			</renderers>
			
		</fop>
		
	</xsl:template>
	
	<xsl:template name="create.font.triplet">
		<xsl:param name="node"/>
		<xsl:param name="alias"/>
		
		<xsl:if test="$node/@normal = 1">
			<font-triplet style="normal" weight="normal">
				<xsl:attribute name="name">
					<xsl:value-of select="$alias"/>
				</xsl:attribute>
			</font-triplet>
		</xsl:if>
		<xsl:if test="$node/@italic = 1">
			<font-triplet style="italic" weight="normal">
				<xsl:attribute name="name">
					<xsl:value-of select="$alias"/>
				</xsl:attribute>
			</font-triplet>
		</xsl:if>
		<xsl:if test="$node/@bold = 1">
			<font-triplet style="normal" weight="bold">
				<xsl:attribute name="name">
					<xsl:value-of select="$alias"/>
				</xsl:attribute>
			</font-triplet>
		</xsl:if>
		
	</xsl:template>
	
	<!--
	설정 파일에 <font></font> 엘리먼트를 만든다.
	-->
	<xsl:template name="create.font.metric">
		<xsl:param name="node"/>
		<xsl:param name="font.dir"/>
		
		<xsl:comment> +++ font configuration for [<xsl:value-of select="$node/@name"/>] +++ </xsl:comment>
		
		<font kerning="yes">
			<xsl:attribute name="metrics-url">
				<xsl:value-of select="$font.dir"/>
				<xsl:value-of select="$node/@name"/>
				<xsl:text>.xml</xsl:text>
			</xsl:attribute>
			<xsl:attribute name="embed-url">
				<xsl:value-of select="$font.dir"/>
				<xsl:value-of select="$node/@name"/>
				<xsl:text>.ttf</xsl:text>
			</xsl:attribute>
			
			<!-- 각각의 alias 에 대하여 -->
			<xsl:for-each select="$node/alias">
				<xsl:if test="string(.) != string(../@name)">
					<xsl:call-template name="create.font.triplet">
						<xsl:with-param name="node" select=".."/>
						<xsl:with-param name="alias" select="."/>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- 폰트명에 대해 -->
			<xsl:call-template name="create.font.triplet">
				<xsl:with-param name="node" select="$node"/>
				<xsl:with-param name="alias" select="$node/@name"/>
			</xsl:call-template>
			
		</font>
		
	</xsl:template>
	
</xsl:stylesheet>
