/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.bridge.SVGFontFamily;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFTextPainter
implements TextPainter {
    private FontInfo fontInfo;
    protected static final TextPainter PROXY_PAINTER = StrokingTextPainter.getInstance();

    public PDFTextPainter(FontInfo fi) {
        this.fontInfo = fi;
    }

    public void paint(TextNode node, Graphics2D g2d) {
        String txt = node.getText();
        Point2D loc = node.getLocation();
        AttributedCharacterIterator aci = node.getAttributedCharacterIterator();
        if (aci.getBeginIndex() == aci.getEndIndex()) {
            return;
        }
        char ch = aci.first();
        if (ch == '\uffff') {
            return;
        }
        TextNode.Anchor anchor = (TextNode.Anchor)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
        List gvtFonts = (List)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES);
        TextPaintInfo tpi = (TextPaintInfo)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO);
        if (tpi == null) {
            return;
        }
        Paint forg = tpi.fillPaint;
        Paint strokePaint = tpi.strokePaint;
        Float size = (Float)aci.getAttribute(TextAttribute.SIZE);
        if (size == null) {
            return;
        }
        Stroke stroke = tpi.strokeStroke;
        Float posture = (Float)aci.getAttribute(TextAttribute.POSTURE);
        Float taWeight = (Float)aci.getAttribute(TextAttribute.WEIGHT);
        boolean useStrokePainter = false;
        if (forg instanceof Color) {
            Color col = (Color)forg;
            if (col.getAlpha() != 255) {
                useStrokePainter = true;
            }
            g2d.setColor(col);
        }
        g2d.setPaint(forg);
        g2d.setStroke(stroke);
        if (strokePaint != null) {
            useStrokePainter = true;
        }
        if (this.hasUnsupportedAttributes(aci)) {
            useStrokePainter = true;
        }
        if (useStrokePainter) {
            PROXY_PAINTER.paint(node, g2d);
            return;
        }
        String style = posture != null && (double)posture.floatValue() > 0.0 ? "italic" : "normal";
        int weight = taWeight != null && (double)taWeight.floatValue() > 1.0 ? 700 : 400;
        org.apache.fop.fonts.Font fontState = null;
        FontInfo fi = this.fontInfo;
        boolean found = false;
        String fontFamily = null;
        if (gvtFonts != null) {
            Iterator i = gvtFonts.iterator();
            while (i.hasNext()) {
                GVTFontFamily fam = (GVTFontFamily)i.next();
                if (fam instanceof SVGFontFamily) {
                    PROXY_PAINTER.paint(node, g2d);
                    return;
                }
                fontFamily = fam.getFamilyName();
                if (!fi.hasFont(fontFamily, style, weight)) continue;
                FontTriplet triplet = this.fontInfo.fontLookup(fontFamily, style, weight);
                int fsize = (int)(size.floatValue() * 1000.0f);
                fontState = this.fontInfo.getFontInstance(triplet, fsize);
                found = true;
                break;
            }
        }
        if (!found) {
            FontTriplet triplet = this.fontInfo.fontLookup("any", style, 400);
            int fsize = (int)(size.floatValue() * 1000.0f);
            fontState = this.fontInfo.getFontInstance(triplet, fsize);
        } else if (g2d instanceof PDFGraphics2D) {
            ((PDFGraphics2D)g2d).setOverrideFontState(fontState);
        }
        int fStyle = 0;
        fStyle = weight == 700 ? (style.equals("italic") ? 3 : 1) : (style.equals("italic") ? 2 : 0);
        Font font = new Font(fontFamily, fStyle, fontState.getFontSize() / 1000);
        g2d.setFont(font);
        float advance = this.getStringWidth(txt, fontState);
        float tx = 0.0f;
        if (anchor != null) {
            switch (anchor.getType()) {
                case 1: {
                    tx = -advance / 2.0f;
                    break;
                }
                case 2: {
                    tx = -advance;
                }
            }
        }
        g2d.drawString(txt, (float)(loc.getX() + (double)tx), (float)loc.getY());
    }

    private boolean hasUnsupportedAttributes(AttributedCharacterIterator aci) {
        Object vertOr;
        GVTAttributedCharacterIterator.TextAttribute key;
        Object writeMod;
        Object wordSpace;
        boolean hasunsupported = false;
        Object letSpace = aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING);
        if (letSpace != null) {
            hasunsupported = true;
        }
        if ((wordSpace = aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING)) != null) {
            hasunsupported = true;
        }
        if (!GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR.equals(writeMod = aci.getAttribute((AttributedCharacterIterator.Attribute)(key = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE)))) {
            hasunsupported = true;
        }
        if (GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE.equals(vertOr = aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION))) {
            hasunsupported = true;
        }
        return hasunsupported;
    }

    private float getStringWidth(String str, org.apache.fop.fonts.Font fontState) {
        float wordWidth = 0.0f;
        float whitespaceWidth = fontState.getWidth(fontState.mapChar(' '));
        for (int i = 0; i < str.length(); ++i) {
            float charWidth;
            char c = str.charAt(i);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                charWidth = fontState.getWidth(fontState.mapChar(c));
                if (charWidth <= 0.0f) {
                    charWidth = whitespaceWidth;
                }
            } else {
                charWidth = whitespaceWidth;
            }
            wordWidth += charWidth;
        }
        return wordWidth / 1000.0f;
    }

    public Shape getOutline(TextNode node) {
        return PROXY_PAINTER.getOutline(node);
    }

    public Rectangle2D getBounds2D(TextNode node) {
        return PROXY_PAINTER.getBounds2D(node);
    }

    public Rectangle2D getGeometryBounds(TextNode node) {
        return PROXY_PAINTER.getGeometryBounds(node);
    }

    public Mark getMark(TextNode node, int pos, boolean all) {
        return null;
    }

    public Mark selectAt(double x, double y, TextNode node) {
        return null;
    }

    public Mark selectTo(double x, double y, Mark beginMark) {
        return null;
    }

    public Mark selectFirst(TextNode node) {
        return null;
    }

    public Mark selectLast(TextNode node) {
        return null;
    }

    public int[] getSelected(Mark start, Mark finish) {
        return null;
    }

    public Shape getHighlightShape(Mark beginMark, Mark endMark) {
        return null;
    }
}

