/*
 * Decompiled with CFR 0.152.
 */
package map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import map.City;

public class JPanelPaint
extends JPanel {
    public static final long serialVersionUID = -193096281977522236L;
    public ImageIcon imageIconMap;
    public City seoul;
    public City hanam;
    public City chuncheon;
    public City hongcheon;
    public City gangneung;
    public City donghae;
    public City samcheok;
    public City yeongjongIsland;
    public City singal;
    public City icheon;
    public City yeoju;
    public City wonju;
    public City jecheon;
    public City pyeongtaek;
    public City anseong;
    public City chungju;
    public City dangjin;
    public City cheonan;
    public City jincheon;
    public City cheongju;
    public City gongju;
    public City daejeon;
    public City sangju;
    public City andong;
    public City yeongdeok;
    public City seocheon;
    public City nonsan;
    public City gunsan;
    public City iksan;
    public City muju;
    public City gimcheon;
    public City pohang;
    public City daegu;
    public City jangsu;
    public City gochang;
    public City hamyang;
    public City hyeonpung;
    public City cheongdo;
    public City eonyang;
    public City ulsan;
    public City busan;
    public City miryang;
    public City naengjeong;
    public City masan;
    public City jinju;
    public City gwangyang;
    public City suncheon;
    public City gwangju;
    public City muan;
    public City mokpo;
    public Vector<City> vecCity;
    public int width;
    public int height;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JPanelPaint panelPaint = new JPanelPaint();
        frame.getContentPane().add(panelPaint);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public JPanelPaint() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initGUI();
        this.generateTopography();
        this.initVector();
    }

    public void initGUI() {
        try {
            this.imageIconMap = new ImageIcon(this.getClass().getClassLoader().getResource("map/skorea.gif"));
            this.width = this.imageIconMap.getIconWidth();
            this.height = this.imageIconMap.getIconHeight();
            this.setPreferredSize(new Dimension(this.width, this.height));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.imageIconMap.paintIcon(this, g, 0, 0);
        for (City c : this.vecCity) {
            if (!c.isVisible()) continue;
            c.drawCircle(g2d);
        }
        this.instructions(g2d, this.width - 200, this.height - 75);
    }

    public void instructions(Graphics2D g, int x, int y) {
        g.setStroke(new BasicStroke(4.0f));
        g.setColor(Color.BLACK);
        g.drawString("**  \ucc38      \uace0  **", x + 56, y + 12);
        int xGreen = x;
        int yGreen = y + 25;
        g.setColor(Color.GREEN.brighter());
        g.fill(new Ellipse2D.Double(xGreen + 1, yGreen + 1, 14.0, 14.0));
        g.setColor(Color.GREEN.darker());
        g.draw(new Ellipse2D.Double(xGreen, yGreen, 16.0, 16.0));
        g.setColor(Color.BLACK);
        g.drawString("\ucd9c\ubc1c \uc704\uce58 \ub610\ub294 \ud30c\uc545\ub41c \ucd5c\uadfc \uc704\uce58", xGreen + 20, yGreen + 12);
        int xRed = x;
        int yRed = y + 50;
        g.setColor(Color.RED.brighter());
        g.fill(new Ellipse2D.Double(xRed + 1, yRed + 1, 14.0, 14.0));
        g.setColor(Color.RED.darker());
        g.draw(new Ellipse2D.Double(xRed, yRed, 16.0, 16.0));
        g.setColor(Color.BLACK);
        g.drawString("\uc608\uc0c1 \ub3c4\ucc29 \uc9c0\uc810 \ub610\ub294 \ubc29\ud5a5", xRed + 20, yRed + 12);
    }

    public void enableCity(String cityCode) {
        for (City c : this.vecCity) {
            if (!c.getIdx().equals(cityCode)) continue;
            c.setColor(Color.GREEN);
            c.setVisible(true);
        }
        this.repaint();
    }

    public void enableCity(String source, String destination) {
        for (City c : this.vecCity) {
            if (c.getIdx().equals(source)) {
                c.setColor(Color.GREEN);
                c.setVisible(true);
                continue;
            }
            if (!c.getIdx().equals(destination)) continue;
            c.setColor(Color.RED);
            c.setVisible(true);
        }
        this.repaint();
    }

    public void disableCity(String cityCode) {
        for (City c : this.vecCity) {
            if (!c.getIdx().equals(cityCode)) continue;
            c.setVisible(false);
        }
        this.repaint();
    }

    public void eraseAll() {
        Iterator<City> iter = this.vecCity.iterator();
        while (iter.hasNext()) {
            iter.next().setVisible(false);
        }
        this.repaint();
    }

    public void generateTopography() {
        this.seoul = new City("0001", "\uc11c\uc6b8", 145.0, 156.0);
        this.hanam = new City("1029", "\ud558\ub0a8", 169.0, 155.0);
        this.chuncheon = new City("2013", "\ucd98\ucc9c", 233.0, 104.0);
        this.hongcheon = new City("2016", "\ud64d\ucc9c", 244.0, 131.0);
        this.gangneung = new City("2001", "\uac15\ub989", 333.0, 119.0);
        this.donghae = new City("2003", "\ub3d9\ud574", 359.0, 158.0);
        this.samcheok = new City("2004", "\uc0bc\ucc99", 380.0, 183.0);
        this.yeongjongIsland = new City("1031", "\uc601\uc885\ub3c4", 62.0, 201.0);
        this.singal = new City("1032", "\uc2e0\uac08", 152.0, 193.0);
        this.icheon = new City("1025", "\uc774\ucc9c", 190.0, 193.0);
        this.yeoju = new City("1019", "\uc5ec\uc8fc", 209.0, 196.0);
        this.wonju = new City("2009", "\uc6d0\uc8fc", 246.0, 180.0);
        this.jecheon = new City("3107", "\uc81c\ucc9c", 271.0, 210.0);
        this.pyeongtaek = new City("1027", "\ud3c9\ud0dd", 130.0, 223.0);
        this.anseong = new City("1015", "\uc548\uc131", 158.0, 221.0);
        this.chungju = new City("3112", "\ucda9\uc8fc", 236.0, 227.0);
        this.dangjin = new City("3205", "\ub2f9\uc9c4", 111.0, 242.0);
        this.cheonan = new City("3213", "\ucc9c\uc548", 160.0, 261.0);
        this.jincheon = new City("3109", "\uc9c4\ucc9c", 196.0, 248.0);
        this.cheongju = new City("3111", "\uccad\uc8fc", 185.0, 287.0);
        this.gongju = new City("3202", "\uacf5\uc8fc", 145.0, 313.0);
        this.daejeon = new City("0006", "\ub300\uc804", 185.0, 316.0);
        this.sangju = new City("5109", "\uc0c1\uc8fc", 274.0, 309.0);
        this.andong = new City("5111", "\uc548\ub3d9", 320.0, 299.0);
        this.yeongdeok = new City("5112", "\uc601\ub355", 397.0, 266.0);
        this.seocheon = new City("3209", "\uc11c\ucc9c", 90.0, 343.0);
        this.nonsan = new City("3204", "\ub17c\uc0b0", 142.0, 356.0);
        this.gunsan = new City("4102", "\uad70\uc0b0", 104.0, 361.0);
        this.iksan = new City("4109", "\uc775\uc0b0", 144.0, 377.0);
        this.muju = new City("4105", "\ubb34\uc8fc", 204.0, 376.0);
        this.gimcheon = new City("5106", "\uae40\ucc9c", 277.0, 346.0);
        this.pohang = new City("5123", "\ud3ec\ud56d", 391.0, 358.0);
        this.daegu = new City("0004", "\ub300\uad6c", 307.0, 383.0);
        this.jangsu = new City("4111", "\uc7a5\uc218", 200.0, 408.0);
        this.gochang = new City("4101", "\uace0\ucc3d", 78.0, 451.0);
        this.hamyang = new City("5221", "\ud568\uc591", 219.0, 434.0);
        this.hyeonpung = new City("5224", "\ud604\ud48d", 295.0, 414.0);
        this.cheongdo = new City("5120", "\uccad\ub3c4", 322.0, 417.0);
        this.eonyang = new City("5211", "\uc5b8\uc591", 370.0, 427.0);
        this.ulsan = new City("5212", "\uc6b8\uc0b0", 400.0, 429.0);
        this.busan = new City("0002", "\ubd80\uc0b0", 363.0, 480.0);
        this.miryang = new City("5207", "\ubc00\uc591", 340.0, 442.0);
        this.naengjeong = new City("5223", "\ub0c9\uc815", 333.0, 480.0);
        this.masan = new City("5206", "\ub9c8\uc0b0", 301.0, 481.0);
        this.jinju = new City("5214", "\uc9c4\uc8fc", 258.0, 500.0);
        this.gwangyang = new City("4204", "\uad11\uc591", 212.0, 530.0);
        this.suncheon = new City("4210", "\uc21c\ucc9c", 187.0, 524.0);
        this.gwangju = new City("0005", "\uad11\uc8fc", 121.0, 481.0);
        this.muan = new City("4222", "\ubb34\uc548", 41.0, 515.0);
        this.mokpo = new City("4208", "\ubaa9\ud3ec", 20.0, 540.0);
    }

    public void initVector() {
        this.vecCity = new Vector();
        this.vecCity.add(this.seoul);
        this.vecCity.add(this.hanam);
        this.vecCity.add(this.chuncheon);
        this.vecCity.add(this.hongcheon);
        this.vecCity.add(this.gangneung);
        this.vecCity.add(this.donghae);
        this.vecCity.add(this.samcheok);
        this.vecCity.add(this.yeongjongIsland);
        this.vecCity.add(this.singal);
        this.vecCity.add(this.icheon);
        this.vecCity.add(this.yeoju);
        this.vecCity.add(this.wonju);
        this.vecCity.add(this.jecheon);
        this.vecCity.add(this.pyeongtaek);
        this.vecCity.add(this.anseong);
        this.vecCity.add(this.chungju);
        this.vecCity.add(this.dangjin);
        this.vecCity.add(this.cheonan);
        this.vecCity.add(this.jincheon);
        this.vecCity.add(this.cheongju);
        this.vecCity.add(this.gongju);
        this.vecCity.add(this.daejeon);
        this.vecCity.add(this.sangju);
        this.vecCity.add(this.andong);
        this.vecCity.add(this.yeongdeok);
        this.vecCity.add(this.seocheon);
        this.vecCity.add(this.nonsan);
        this.vecCity.add(this.gunsan);
        this.vecCity.add(this.iksan);
        this.vecCity.add(this.muju);
        this.vecCity.add(this.gimcheon);
        this.vecCity.add(this.pohang);
        this.vecCity.add(this.daegu);
        this.vecCity.add(this.jangsu);
        this.vecCity.add(this.gochang);
        this.vecCity.add(this.hamyang);
        this.vecCity.add(this.hyeonpung);
        this.vecCity.add(this.cheongdo);
        this.vecCity.add(this.eonyang);
        this.vecCity.add(this.ulsan);
        this.vecCity.add(this.busan);
        this.vecCity.add(this.miryang);
        this.vecCity.add(this.naengjeong);
        this.vecCity.add(this.masan);
        this.vecCity.add(this.jinju);
        this.vecCity.add(this.gwangyang);
        this.vecCity.add(this.suncheon);
        this.vecCity.add(this.gwangju);
        this.vecCity.add(this.muan);
        this.vecCity.add(this.mokpo);
    }
}

